/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.management.HasTaskChildren;
import brooklyn.management.Task;
import brooklyn.rest.api.ActivityApi;
import brooklyn.rest.domain.TaskSummary;
import brooklyn.rest.resources.AbstractBrooklynRestResource;
import brooklyn.rest.transform.TaskTransformer;
import brooklyn.rest.util.WebResourceUtils;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ActivityResource
extends AbstractBrooklynRestResource
implements ActivityApi {
    public TaskSummary get(String taskId) {
        Task t = this.mgmt().getExecutionManager().getTask(taskId);
        if (t == null) {
            throw WebResourceUtils.notFound("Cannot find task '%s'", taskId);
        }
        return (TaskSummary)TaskTransformer.FROM_TASK.apply((Object)t);
    }

    public List<TaskSummary> children(String taskId) {
        Task t = this.mgmt().getExecutionManager().getTask(taskId);
        if (t == null) {
            throw WebResourceUtils.notFound("Cannot find task '%s'", taskId);
        }
        if (!(t instanceof HasTaskChildren)) {
            return Collections.emptyList();
        }
        return new LinkedList<TaskSummary>(Collections2.transform((Collection)Lists.newArrayList((Iterable)((HasTaskChildren)t).getChildren()), TaskTransformer.FROM_TASK));
    }

    public String stream(String taskId, String streamId) {
        Task t = this.mgmt().getExecutionManager().getTask(taskId);
        if (t == null) {
            throw WebResourceUtils.notFound("Cannot find task '%s'", taskId);
        }
        BrooklynTaskTags.WrappedStream stream = BrooklynTaskTags.stream((Task)t, (String)streamId);
        if (stream == null) {
            throw WebResourceUtils.notFound("Cannot find stream '%s' in task '%s'", streamId, taskId);
        }
        return (String)stream.streamContents.get();
    }
}

