/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.config.BrooklynServerConfig;
import brooklyn.config.BrooklynServiceAttributes;
import brooklyn.management.ManagementContext;
import brooklyn.management.ManagementContextInjectable;
import brooklyn.rest.util.BrooklynRestResourceUtils;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.rest.util.json.BrooklynJacksonJsonProvider;
import brooklyn.util.guava.Maybe;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import com.google.common.annotations.VisibleForTesting;
import io.brooklyn.camp.CampPlatform;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AbstractBrooklynRestResource
implements ManagementContextInjectable {
    @VisibleForTesting
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    @Context
    ServletContext servletContext;
    private ManagementContext managementContext;
    private BrooklynRestResourceUtils brooklynRestResourceUtils;
    private ObjectMapper mapper;

    public ManagementContext mgmt() {
        return (ManagementContext)this.mgmtMaybe().get();
    }

    protected synchronized Maybe<ManagementContext> mgmtMaybe() {
        if (this.managementContext != null) {
            return Maybe.of((Object)this.managementContext);
        }
        this.managementContext = (ManagementContext)this.servletContext.getAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT);
        if (this.managementContext != null) {
            return Maybe.of((Object)this.managementContext);
        }
        return Maybe.absent((String)("ManagementContext not available for Brooklyn Jersey Resource " + this));
    }

    public void injectManagementContext(ManagementContext managementContext) {
        if (this.managementContext != null) {
            if (this.managementContext.equals(managementContext)) {
                return;
            }
            throw new IllegalStateException("ManagementContext cannot be changed: specified twice for Brooklyn Jersey Resource " + this);
        }
        this.managementContext = managementContext;
    }

    public synchronized BrooklynRestResourceUtils brooklyn() {
        if (this.brooklynRestResourceUtils != null) {
            return this.brooklynRestResourceUtils;
        }
        this.brooklynRestResourceUtils = new BrooklynRestResourceUtils(this.mgmt());
        return this.brooklynRestResourceUtils;
    }

    protected ObjectMapper mapper() {
        if (this.mapper == null) {
            this.mapper = BrooklynJacksonJsonProvider.findAnyObjectMapper(this.servletContext, this.managementContext);
        }
        return this.mapper;
    }

    protected Object getValueForDisplay(Object value, boolean preferJson, boolean isJerseyReturnValue) {
        Object immediate = this.getImmediateValue(value);
        return WebResourceUtils.getValueForDisplay(this.mapper(), immediate, preferJson, isJerseyReturnValue);
    }

    private Object getImmediateValue(Object value) {
        return Tasks.resolving((Object)value).as(Object.class).defaultValue(null).timeout(Duration.ZERO).swallowExceptions().get();
    }

    protected CampPlatform camp() {
        return (CampPlatform)BrooklynServerConfig.getCampPlatform((ManagementContext)this.mgmt()).get();
    }
}

