/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.filter;

import brooklyn.config.BrooklynServiceAttributes;
import brooklyn.management.ManagementContext;
import brooklyn.management.entitlement.EntitlementContext;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.management.entitlement.WebEntitlementContext;
import brooklyn.rest.filter.RequestTaggingFilter;
import brooklyn.rest.security.provider.DelegatingSecurityProvider;
import brooklyn.util.text.Strings;
import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynPropertiesSecurityFilter
implements Filter {
    public static final String AUTHENTICATED_USER_SESSION_ATTRIBUTE = "brooklyn.user";
    public static final String REMOTE_ADDRESS_SESSION_ATTRIBUTE = "request.remoteAddress";
    private static final Logger log = LoggerFactory.getLogger(BrooklynPropertiesSecurityFilter.class);
    protected DelegatingSecurityProvider provider;
    private static ThreadLocal<String> originalRequest = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        if (this.provider == null) {
            log.warn("No security provider available: disallowing web access to brooklyn");
            httpResponse.sendError(503);
            return;
        }
        if (originalRequest.get() != null) {
            Entitlements.clearEntitlementContext();
        } else {
            originalRequest.set(uri);
        }
        boolean authenticated = this.provider.isAuthenticated(httpRequest.getSession());
        if ("/logout".equals(uri) || "/v1/logout".equals(uri)) {
            httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"brooklyn\"");
            if (authenticated && httpRequest.getSession().getAttributeNames().hasMoreElements()) {
                this.logout(httpRequest);
                httpResponse.sendError(401);
            } else {
                RequestDispatcher dispatcher = httpRequest.getRequestDispatcher("/");
                log.debug("Not authenticated, forwarding request for {} to {}", (Object)uri, (Object)dispatcher);
                dispatcher.forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            return;
        }
        if (!httpRequest.getSession().getAttributeNames().hasMoreElements() || !this.provider.isAuthenticated(httpRequest.getSession()) || "/logout".equals(originalRequest.get())) {
            authenticated = this.authenticate(httpRequest);
        }
        if (!authenticated) {
            httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"brooklyn\"");
            httpResponse.sendError(401);
            return;
        }
        String uid = RequestTaggingFilter.getTag();
        String user = Strings.toString((Object)httpRequest.getSession().getAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE));
        try {
            WebEntitlementContext entitlementContext = new WebEntitlementContext(user, httpRequest.getRemoteAddr(), uri, uid);
            Entitlements.setEntitlementContext((EntitlementContext)entitlementContext);
            chain.doFilter(request, response);
        }
        catch (Throwable e) {
            if (!response.isCommitted()) {
                httpResponse.sendError(500);
            }
        }
        finally {
            originalRequest.remove();
            Entitlements.clearEntitlementContext();
        }
    }

    protected boolean authenticate(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (this.provider.isAuthenticated(session)) {
            return true;
        }
        session.setAttribute(REMOTE_ADDRESS_SESSION_ATTRIBUTE, (Object)request.getRemoteAddr());
        String user = null;
        String pass = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null) {
            String userpass = Base64.base64Decode((String)authorization.substring(6));
            user = userpass.substring(0, userpass.indexOf(":"));
            pass = userpass.substring(userpass.indexOf(":") + 1);
        }
        if (this.provider.authenticate(session, user, pass)) {
            if (user != null) {
                session.setAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE, (Object)user);
            }
            return true;
        }
        return false;
    }

    public void init(FilterConfig config) throws ServletException {
        ManagementContext mgmt = (ManagementContext)config.getServletContext().getAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT);
        this.provider = new DelegatingSecurityProvider(mgmt);
    }

    public void destroy() {
    }

    protected void logout(HttpServletRequest request) {
        log.info("REST logging {} out of session {}", request.getSession().getAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE), (Object)request.getSession().getId());
        this.provider.logout(request.getSession());
        request.getSession().removeAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE);
        request.getSession().removeAttribute(REMOTE_ADDRESS_SESSION_ATTRIBUTE);
        request.getSession().invalidate();
    }
}

