/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.loadbalancing;

import brooklyn.policy.loadbalancing.BalanceablePoolModel;
import brooklyn.policy.loadbalancing.LocationConstraint;
import java.util.Set;

public class PolicyUtilForPool<ContainerType, ItemType> {
    private final BalanceablePoolModel<ContainerType, ItemType> model;

    public PolicyUtilForPool(BalanceablePoolModel<ContainerType, ItemType> model) {
        this.model = model;
    }

    public ContainerType findColdestContainer(Set<ContainerType> excludedContainers) {
        return this.findColdestContainer(excludedContainers, null);
    }

    public ContainerType findColdestContainer(Set<ContainerType> excludedContainers, LocationConstraint locationConstraint) {
        double maxSpareCapacity = 0.0;
        ContainerType coldest = null;
        for (ContainerType c : this.model.getPoolContents()) {
            if (excludedContainers.contains(c) || locationConstraint != null && !locationConstraint.isPermitted(this.model.getLocation(c))) continue;
            double highThreshold = this.model.getHighThreshold(c);
            double totalWorkrate = this.model.getTotalWorkrate(c);
            double spareCapacity = highThreshold - totalWorkrate;
            if (highThreshold == -1.0 || totalWorkrate == -1.0 || !(spareCapacity > maxSpareCapacity)) continue;
            maxSpareCapacity = spareCapacity;
            coldest = c;
        }
        return coldest;
    }

    public ContainerType findHottestContainer(Set<ContainerType> excludedContainers) {
        double maxOvershoot = 0.0;
        ContainerType hottest = null;
        for (ContainerType c : this.model.getPoolContents()) {
            if (excludedContainers.contains(c)) continue;
            double totalWorkrate = this.model.getTotalWorkrate(c);
            double highThreshold = this.model.getHighThreshold(c);
            double overshoot = totalWorkrate - highThreshold;
            if (highThreshold == -1.0 || totalWorkrate == -1.0 || !(overshoot > maxOvershoot)) continue;
            maxOvershoot = overshoot;
            hottest = c;
        }
        return hottest;
    }
}

