/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.loadbalancing;

import brooklyn.entity.Entity;
import brooklyn.location.Location;
import brooklyn.policy.loadbalancing.BalanceablePoolModel;
import brooklyn.policy.loadbalancing.Movable;
import brooklyn.policy.loadbalancing.PolicyUtilForPool;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancingStrategy<NodeType extends Entity, ItemType extends Movable> {
    private static final Logger LOG = LoggerFactory.getLogger(BalancingStrategy.class);
    private static final int MAX_MIGRATIONS_PER_BALANCING_NODE = 20;
    private static final boolean BALANCE_COLD_PULLS_IN_SAME_RUN_AS_HOT_PUSHES = false;
    private final String name;
    private final BalanceablePoolModel<NodeType, ItemType> model;
    private final PolicyUtilForPool<NodeType, ItemType> helper;

    public BalancingStrategy(String name, BalanceablePoolModel<NodeType, ItemType> model) {
        this.name = name;
        this.model = model;
        this.helper = new PolicyUtilForPool<NodeType, ItemType>(model);
    }

    public String getName() {
        return this.name;
    }

    public void rebalance() {
        this.checkAndApplyOn(this.model.getPoolContents());
    }

    public int getMaxMigrationsPerBalancingNode() {
        return 20;
    }

    public BalanceablePoolModel<NodeType, ItemType> getDataProvider() {
        return this.model;
    }

    private void checkAndApplyOn(Collection<NodeType> dirtyNodesSupplied) {
        Collection<NodeType> dirtyNodes = dirtyNodesSupplied;
        boolean gonnaGrow = false;
        LinkedHashSet<NodeType> nonFrozenDirtyNodes = new LinkedHashSet<NodeType>(dirtyNodes);
        if (this.getDataProvider().getPoolSize() >= 2) {
            boolean didBalancing = false;
            for (Entity a : nonFrozenDirtyNodes) {
                didBalancing |= this.balanceItemsOnNodesInQuestion(a, gonnaGrow);
            }
            if (didBalancing) {
                return;
            }
        }
    }

    protected boolean balanceItemsOnNodesInQuestion(NodeType questionedNode, boolean gonnaGrow) {
        double questionedNodeTotalWorkrate = this.getDataProvider().getTotalWorkrate(questionedNode);
        boolean balanced = this.balanceItemsOnHotNode(questionedNode, questionedNodeTotalWorkrate, gonnaGrow);
        if (!balanced) {
            balanced |= this.balanceItemsOnColdNode(questionedNode, questionedNodeTotalWorkrate, gonnaGrow);
        }
        if (balanced) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " not balancing " + questionedNode + "; " + "its workrate {0,number,#.##} is acceptable (or cannot be balanced)", questionedNodeTotalWorkrate));
        }
        return false;
    }

    protected boolean balanceItemsOnHotNode(NodeType node, double nodeWorkrate, boolean gonnaGrow) {
        double originalNodeWorkrate = nodeWorkrate;
        int iterationCount = 0;
        LinkedHashSet<ItemType> itemsMoved = new LinkedHashSet<ItemType>();
        LinkedHashSet nodesChecked = new LinkedHashSet();
        Double highThreshold = this.model.getHighThreshold(node);
        if (highThreshold == -1.0) {
            return false;
        }
        for (int migrationCount = 0; nodeWorkrate > highThreshold && migrationCount < this.getMaxMigrationsPerBalancingNode(); ++migrationCount) {
            double idealSizeToMove;
            Entity coldNode;
            ++iterationCount;
            if (LOG.isDebugEnabled()) {
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " considering balancing hot node " + node + " " + "(workrate {0,number,#.##}); iteration " + iterationCount, nodeWorkrate));
            }
            if ((coldNode = (Entity)this.helper.findColdestContainer(nodesChecked)) == null) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " not balancing hot node " + node + " " + "(workrate {0,number,#.##}); no coldest node available", nodeWorkrate));
                break;
            }
            if (coldNode.equals(node)) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " not balancing hot node " + node + " " + "(workrate {0,number,#.##}); it is also the coldest modifiable node", nodeWorkrate));
                break;
            }
            double coldNodeWorkrate = this.getDataProvider().getTotalWorkrate(coldNode);
            boolean emergencyLoadBalancing = coldNodeWorkrate < nodeWorkrate * 2.0 / 3.0;
            double coldNodeHighThreshold = this.model.getHighThreshold(coldNode);
            if (coldNodeWorkrate >= coldNodeHighThreshold && !emergencyLoadBalancing) break;
            double poolLowWatermark = Double.MAX_VALUE;
            if (gonnaGrow && coldNodeWorkrate >= poolLowWatermark && !emergencyLoadBalancing) break;
            String questionedNodeName = this.getDataProvider().getName(node);
            String coldNodeName = this.getDataProvider().getName(coldNode);
            Location coldNodeLocation = this.getDataProvider().getLocation(coldNode);
            if (LOG.isDebugEnabled()) {
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing hot node " + questionedNodeName + " " + "(" + node + ", workrate {0,number,#.##}), " + "considering target " + coldNodeName + " (" + coldNode + ", workrate {1,number,#.##})", nodeWorkrate, coldNodeWorkrate));
            }
            if ((idealSizeToMove = (nodeWorkrate - coldNodeWorkrate) / 2.0) + coldNodeWorkrate > coldNodeHighThreshold) {
                idealSizeToMove = coldNodeHighThreshold - coldNodeWorkrate;
            }
            double maxSizeToMoveIdeally = Math.min(nodeWorkrate / 2.0 + 1.0E-5, (nodeWorkrate - coldNodeWorkrate) * 0.9);
            double maxSizeToMoveIfNoSmallButLarger = nodeWorkrate * 3.0 / 4.0;
            Map<ItemType, Double> questionedNodeItems = this.getDataProvider().getItemWorkrates(node);
            if (questionedNodeItems == null) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing hot node " + questionedNodeName + " " + "(" + node + ", workrate {0,number,#.##}), abandoned; " + "item report for " + questionedNodeName + " unavailable", nodeWorkrate));
                break;
            }
            ItemType itemToMove = this.findBestItemToMove(questionedNodeItems, idealSizeToMove, maxSizeToMoveIdeally, maxSizeToMoveIfNoSmallButLarger, itemsMoved, coldNodeLocation);
            if (itemToMove == null) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing hot node " + questionedNodeName + " " + "(" + node + ", workrate {0,number,#.##}), ending; " + "no suitable segment found " + "(ideal transition item size {1,number,#.##}, max {2,number,#.##}, " + "moving to coldest node " + coldNodeName + " (" + coldNode + ", workrate {3,number,#.##}); available items: {4}", nodeWorkrate, idealSizeToMove, maxSizeToMoveIdeally, coldNodeWorkrate, questionedNodeItems));
                break;
            }
            itemsMoved.add(itemToMove);
            double itemWorkrate = questionedNodeItems.get(itemToMove);
            nodeWorkrate -= itemWorkrate;
            coldNodeWorkrate += itemWorkrate;
            this.moveItem(itemToMove, node, coldNode);
        }
        if (LOG.isDebugEnabled()) {
            if (iterationCount == 0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing if hot finished at node " + node + "; " + "workrate {0,number,#.##} not hot", originalNodeWorkrate));
                }
            } else if (itemsMoved.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing finished at hot node " + node + " " + "(workrate {0,number,#.##}); no way to improve it", originalNodeWorkrate));
                }
            } else {
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing finished at hot node " + node + "; " + "workrate from {0,number,#.##} to {1,number,#.##} (report now says {2,number,#.##}) " + "by moving off {3}", originalNodeWorkrate, nodeWorkrate, this.getDataProvider().getTotalWorkrate(node), itemsMoved));
            }
        }
        return !itemsMoved.isEmpty();
    }

    protected boolean balanceItemsOnColdNode(NodeType questionedNode, double questionedNodeTotalWorkrate, boolean gonnaGrow) {
        Map<ItemType, Double> items = this.getDataProvider().getItemWorkrates(questionedNode);
        if (items == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " not balancing cold node " + questionedNode + " " + "(workrate {0,number,#.##}); workrate breakdown unavailable (probably reverting)", questionedNodeTotalWorkrate));
            }
            return false;
        }
        for (Movable item : items.keySet()) {
            if (this.model.isItemMoveable(item)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " not balancing cold node " + questionedNode + " " + "(workrate {0,number,#.##}); at least one item (" + item + ") is in flux", questionedNodeTotalWorkrate));
            }
            return false;
        }
        double originalQuestionedNodeTotalWorkrate = questionedNodeTotalWorkrate;
        int numMigrations = 0;
        LinkedHashSet<ItemType> itemsMoved = new LinkedHashSet<ItemType>();
        LinkedHashSet<Entity> nodesChecked = new LinkedHashSet<Entity>();
        int iters = 0;
        Location questionedLocation = this.getDataProvider().getLocation(questionedNode);
        double lowThreshold = this.model.getLowThreshold(questionedNode);
        while (questionedNodeTotalWorkrate < lowThreshold) {
            double targetNodeHighThreshold;
            double idealSizeToMove;
            Entity hotNode;
            ++iters;
            if (LOG.isDebugEnabled()) {
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " considering balancing cold node " + questionedNode + " " + "(workrate {0,number,#.##}); iteration " + iters, questionedNodeTotalWorkrate));
            }
            if ((hotNode = (Entity)this.helper.findHottestContainer(nodesChecked)) == null) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " not balancing cold node " + questionedNode + " " + "(workrate {0,number,#.##}); no hottest node available", questionedNodeTotalWorkrate));
                break;
            }
            if (hotNode.equals(questionedNode)) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " not balancing cold node " + questionedNode + " " + "(workrate {0,number,#.##}); it is also the hottest modfiable node", questionedNodeTotalWorkrate));
                break;
            }
            double hotNodeWorkrate = this.getDataProvider().getTotalWorkrate(hotNode);
            double hotNodeLowThreshold = this.model.getLowThreshold(hotNode);
            double hotNodeHighThreshold = this.model.getHighThreshold(hotNode);
            boolean emergencyLoadBalancing = false;
            if (hotNodeWorkrate == -1.0 || hotNodeLowThreshold == -1.0 || hotNodeHighThreshold == -1.0 || hotNodeWorkrate <= hotNodeLowThreshold && !emergencyLoadBalancing || gonnaGrow && hotNodeWorkrate <= hotNodeHighThreshold && !emergencyLoadBalancing) break;
            String questionedNodeName = this.getDataProvider().getName(questionedNode);
            String hotNodeName = this.getDataProvider().getName(hotNode);
            if (LOG.isDebugEnabled()) {
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing cold node " + questionedNodeName + " " + "(" + questionedNode + ", workrate {0,number,#.##}), " + "considering source " + hotNodeName + " (" + hotNode + ", workrate {1,number,#.##})", questionedNodeTotalWorkrate, hotNodeWorkrate));
            }
            if ((idealSizeToMove = (hotNodeWorkrate - questionedNodeTotalWorkrate) / 2.0) + questionedNodeTotalWorkrate > (targetNodeHighThreshold = this.model.getHighThreshold(questionedNode))) {
                idealSizeToMove = targetNodeHighThreshold - questionedNodeTotalWorkrate;
            }
            double maxSizeToMoveIdeally = Math.min(hotNodeWorkrate / 2.0, (hotNodeWorkrate - questionedNodeTotalWorkrate) * 0.6);
            double maxSizeToMoveIfNoSmallButLarger = questionedNodeTotalWorkrate * 3.0 / 4.0;
            Map<ItemType, Double> hotNodeItems = this.getDataProvider().getItemWorkrates(hotNode);
            if (hotNodeItems == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing cold node " + questionedNodeName + " " + "(" + questionedNode + ", workrate {0,number,#.##}), " + "excluding hot node " + hotNodeName + " because its item report unavailable", questionedNodeTotalWorkrate));
                }
                nodesChecked.add(hotNode);
                continue;
            }
            ItemType itemToMove = this.findBestItemToMove(hotNodeItems, idealSizeToMove, maxSizeToMoveIdeally, maxSizeToMoveIfNoSmallButLarger, itemsMoved, questionedLocation);
            if (itemToMove == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing cold node " + questionedNodeName + " " + "(" + questionedNode + ", workrate {0,number,#.##}), " + "excluding hot node " + hotNodeName + " because it has no appilcable items " + "(ideal transition item size {1,number,#.##}, max {2,number,#.##}, " + "moving from hot node " + hotNodeName + " (" + hotNode + ", workrate {3,number,#.##}); available items: {4}", questionedNodeTotalWorkrate, idealSizeToMove, maxSizeToMoveIdeally, hotNodeWorkrate, hotNodeItems));
                }
                nodesChecked.add(hotNode);
                continue;
            }
            itemsMoved.add(itemToMove);
            double segmentRate = hotNodeItems.get(itemToMove);
            questionedNodeTotalWorkrate += segmentRate;
            hotNodeWorkrate -= segmentRate;
            this.moveItem(itemToMove, hotNode, questionedNode);
            if (++numMigrations < this.getMaxMigrationsPerBalancingNode()) continue;
            break;
        }
        if (LOG.isDebugEnabled()) {
            if (iters == 0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing if cold finished at node " + questionedNode + "; " + "workrate {0,number,#.##} not cold", originalQuestionedNodeTotalWorkrate));
                }
            } else if (itemsMoved.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing finished at cold node " + questionedNode + " " + "(workrate {0,number,#.##}); no way to improve it", originalQuestionedNodeTotalWorkrate));
                }
            } else {
                LOG.debug(MessageFormat.format("policy " + this.getDataProvider().getName() + " balancing finished at cold node " + questionedNode + "; " + "workrate from {0,number,#.##} to {1,number,#.##} (report now says {2,number,#.##}) " + "by moving in {3}", originalQuestionedNodeTotalWorkrate, questionedNodeTotalWorkrate, this.getDataProvider().getTotalWorkrate(questionedNode), itemsMoved));
            }
        }
        return !itemsMoved.isEmpty();
    }

    protected void moveItem(ItemType item, NodeType oldNode, NodeType newNode) {
        item.move((Entity)newNode);
        this.model.onItemMoved(item, newNode);
    }

    protected ItemType findBestItemToMove(Map<ItemType, Double> costsPerItem, double targetCost, double maxCost, double maxCostIfNothingSmallerButLarger, Set<ItemType> excludedItems, Location locationIfKnown) {
        Movable closestMatch = null;
        Movable smallestMoveable = null;
        Movable largest = null;
        double minDiff = Double.MAX_VALUE;
        double smallestC = Double.MAX_VALUE;
        double largestC = Double.MIN_VALUE;
        boolean exclusions = false;
        for (Map.Entry<ItemType, Double> entry : costsPerItem.entrySet()) {
            Movable item = (Movable)entry.getKey();
            Double cost = entry.getValue();
            if (cost == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(MessageFormat.format("Item ''{0}'' has null workrate: skipping", item));
                continue;
            }
            if (!this.model.isItemMoveable(item)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(MessageFormat.format("Item ''{0}'' cannot be moved: skipping", item));
                continue;
            }
            if (cost < 0.0) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(MessageFormat.format("Item ''{0}'' subject to recent adjustment: skipping", item));
                continue;
            }
            if (excludedItems.contains(item)) {
                exclusions = true;
                continue;
            }
            if (cost < 0.0) {
                exclusions = true;
                continue;
            }
            if (cost <= 0.0) continue;
            if (largest == null || cost > largestC) {
                largest = item;
                largestC = cost;
            }
            if (!this.model.isItemMoveable(item) || locationIfKnown != null && !this.model.isItemAllowedIn(item, locationIfKnown)) continue;
            if (smallestMoveable == null || cost < smallestC) {
                smallestMoveable = item;
                smallestC = cost;
            }
            if (cost > maxCost) continue;
            double diff = Math.abs(targetCost - cost);
            if (closestMatch != null && !(diff < minDiff)) continue;
            closestMatch = item;
            minDiff = diff;
        }
        if (closestMatch != null) {
            return (ItemType)closestMatch;
        }
        if (smallestC < maxCostIfNothingSmallerButLarger && smallestC < largestC && !exclusions) {
            return (ItemType)smallestMoveable;
        }
        return null;
    }
}

