/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.ha;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.event.SensorEvent;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.event.basic.BasicNotificationSensor;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.policy.ha.HASensors;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.task.BasicTask;
import brooklyn.util.task.ScheduledTask;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFailureDetector
extends ServiceStateLogic.ComputeServiceState {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceFailureDetector.class);
    private static final long MIN_PERIOD_BETWEEN_EXECS_MILLIS = 100L;
    public static final BasicNotificationSensor<HASensors.FailureDescriptor> ENTITY_FAILED = HASensors.ENTITY_FAILED;
    @SetFromFlag(value="onlyReportIfPreviouslyUp")
    public static final ConfigKey<Boolean> ENTITY_FAILED_ONLY_IF_PREVIOUSLY_UP = ConfigKeys.newBooleanConfigKey((String)"onlyReportIfPreviouslyUp", (String)"Prevents the policy from emitting ENTITY_FAILED if the entity fails on startup (ie has never been up)", (Boolean)true);
    public static final ConfigKey<Boolean> MONITOR_SERVICE_PROBLEMS = ConfigKeys.newBooleanConfigKey((String)"monitorServiceProblems", (String)"Whether to monitor service problems, and emit on failures there (if set to false, this monitors only service up)", (Boolean)true);
    @SetFromFlag(value="serviceOnFireStabilizationDelay")
    public static final ConfigKey<Duration> SERVICE_ON_FIRE_STABILIZATION_DELAY = BasicConfigKey.builder(Duration.class).name("serviceOnFire.stabilizationDelay").description("Time period for which the service must be consistently down for (e.g. doesn't report down-up-down) before concluding ON_FIRE").defaultValue((Object)Duration.ZERO).build();
    @SetFromFlag(value="entityFailedStabilizationDelay")
    public static final ConfigKey<Duration> ENTITY_FAILED_STABILIZATION_DELAY = BasicConfigKey.builder(Duration.class).name("entityFailed.stabilizationDelay").description("Time period for which the service must be consistently down for (e.g. doesn't report down-up-down) before emitting ENTITY_FAILED").defaultValue((Object)Duration.ZERO).build();
    @SetFromFlag(value="entityRecoveredStabilizationDelay")
    public static final ConfigKey<Duration> ENTITY_RECOVERED_STABILIZATION_DELAY = BasicConfigKey.builder(Duration.class).name("entityRecovered.stabilizationDelay").description("For a failed entity, time period for which the service must be consistently up for (e.g. doesn't report up-down-up) before emitting ENTITY_RECOVERED").defaultValue((Object)Duration.ZERO).build();
    @SetFromFlag(value="entityFailedRepublishTime")
    public static final ConfigKey<Duration> ENTITY_FAILED_REPUBLISH_TIME = BasicConfigKey.builder(Duration.class).name("entityFailed.republishTime").description("Publish failed state periodically at the specified intervals, null to disable.").build();
    protected Long firstUpTime;
    protected Long currentFailureStartTime = null;
    protected Long currentRecoveryStartTime = null;
    protected Long publishEntityFailedTime = null;
    protected Long publishEntityRecoveredTime = null;
    protected Long setEntityOnFireTime = null;
    protected LastPublished lastPublished = LastPublished.NONE;
    private final AtomicBoolean executorQueued = new AtomicBoolean(false);
    private volatile long executorTime = 0L;
    private final Object mutex = new Object();

    public ServiceFailureDetector() {
        this(new ConfigBag());
    }

    public ServiceFailureDetector(Map<String, ?> flags) {
        this(new ConfigBag().putAll(flags));
    }

    public ServiceFailureDetector(ConfigBag configBag) {
        super(configBag.getAllConfigMutable());
    }

    public void onEvent(SensorEvent<Object> event) {
        if (this.firstUpTime == null) {
            if (event != null && Attributes.SERVICE_UP.equals(event.getSensor()) && Boolean.TRUE.equals(event.getValue())) {
                this.firstUpTime = event.getTimestamp();
            } else if (event == null && Boolean.TRUE.equals(this.entity.getAttribute(Attributes.SERVICE_UP))) {
                this.firstUpTime = System.currentTimeMillis();
            }
        }
        super.onEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActualState(Lifecycle state) {
        long now = System.currentTimeMillis();
        Object object = this.mutex;
        synchronized (object) {
            long delayBeforeCheck;
            if (state == Lifecycle.ON_FIRE) {
                if (this.lastPublished == LastPublished.FAILED) {
                    if (this.currentRecoveryStartTime != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} health-check for {}, component was recovering, now failing: {}", new Object[]{this, this.entity, this.getExplanation(state)});
                        }
                        this.currentRecoveryStartTime = null;
                        this.publishEntityRecoveredTime = null;
                    } else if (LOG.isTraceEnabled()) {
                        LOG.trace("{} health-check for {}, component still failed: {}", new Object[]{this, this.entity, this.getExplanation(state)});
                    }
                } else if (this.firstUpTime != null || !((Boolean)this.getConfig(ENTITY_FAILED_ONLY_IF_PREVIOUSLY_UP)).booleanValue()) {
                    if (this.currentFailureStartTime == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} health-check for {}, component now failing: {}", new Object[]{this, this.entity, this.getExplanation(state)});
                        }
                        this.currentFailureStartTime = now;
                        this.publishEntityFailedTime = this.currentFailureStartTime + ((Duration)this.getConfig(ENTITY_FAILED_STABILIZATION_DELAY)).toMilliseconds();
                    } else if (LOG.isTraceEnabled()) {
                        LOG.trace("{} health-check for {}, component continuing failing: {}", new Object[]{this, this.entity, this.getExplanation(state)});
                    }
                }
                if (this.setEntityOnFireTime == null) {
                    this.setEntityOnFireTime = now + ((Duration)this.getConfig(SERVICE_ON_FIRE_STABILIZATION_DELAY)).toMilliseconds();
                }
                this.currentRecoveryStartTime = null;
                this.publishEntityRecoveredTime = null;
            } else if (state == Lifecycle.RUNNING) {
                if (this.lastPublished == LastPublished.FAILED) {
                    if (this.currentRecoveryStartTime == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} health-check for {}, component now recovering: {}", new Object[]{this, this.entity, this.getExplanation(state)});
                        }
                        this.currentRecoveryStartTime = now;
                        this.publishEntityRecoveredTime = this.currentRecoveryStartTime + ((Duration)this.getConfig(ENTITY_RECOVERED_STABILIZATION_DELAY)).toMilliseconds();
                    } else if (LOG.isTraceEnabled()) {
                        LOG.trace("{} health-check for {}, component continuing recovering: {}", new Object[]{this, this.entity, this.getExplanation(state)});
                    }
                } else if (this.currentFailureStartTime != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} health-check for {}, component was failing, now healthy: {}", new Object[]{this, this.entity, this.getExplanation(state)});
                    }
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace("{} health-check for {}, component still healthy: {}", new Object[]{this, this.entity, this.getExplanation(state)});
                }
                this.currentFailureStartTime = null;
                this.publishEntityFailedTime = null;
                this.setEntityOnFireTime = null;
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("{} health-check for {}, in unconfirmed sate: {}", new Object[]{this, this.entity, this.getExplanation(state)});
            }
            long recomputeIn = Long.MAX_VALUE;
            if (this.publishEntityFailedTime != null) {
                delayBeforeCheck = this.publishEntityFailedTime - now;
                if (delayBeforeCheck <= 0L) {
                    Duration republishDelay;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} publishing failed (state={}; currentFailureStartTime={}; now={}", new Object[]{this, state, Time.makeDateString((long)this.currentFailureStartTime), Time.makeDateString((long)now)});
                    }
                    if ((republishDelay = (Duration)this.getConfig(ENTITY_FAILED_REPUBLISH_TIME)) == null) {
                        this.publishEntityFailedTime = null;
                    } else {
                        this.publishEntityFailedTime = now + republishDelay.toMilliseconds();
                        recomputeIn = Math.min(recomputeIn, republishDelay.toMilliseconds());
                    }
                    this.lastPublished = LastPublished.FAILED;
                    this.entity.emit(HASensors.ENTITY_FAILED, (Object)new HASensors.FailureDescriptor(this.entity, this.getFailureDescription(now)));
                } else {
                    recomputeIn = Math.min(recomputeIn, delayBeforeCheck);
                }
            } else if (this.publishEntityRecoveredTime != null) {
                delayBeforeCheck = this.publishEntityRecoveredTime - now;
                if (delayBeforeCheck <= 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} publishing recovered (state={}; currentRecoveryStartTime={}; now={}", new Object[]{this, state, Time.makeDateString((long)this.currentRecoveryStartTime), Time.makeDateString((long)now)});
                    }
                    this.publishEntityRecoveredTime = null;
                    this.lastPublished = LastPublished.RECOVERED;
                    this.entity.emit(HASensors.ENTITY_RECOVERED, (Object)new HASensors.FailureDescriptor(this.entity, null));
                } else {
                    recomputeIn = Math.min(recomputeIn, delayBeforeCheck);
                }
            }
            if (this.setEntityOnFireTime != null) {
                delayBeforeCheck = this.setEntityOnFireTime - now;
                if (delayBeforeCheck <= 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} setting on-fire, now that deferred period has passed (state={})", new Object[]{this, state});
                    }
                    this.setEntityOnFireTime = null;
                    super.setActualState(state);
                } else {
                    recomputeIn = Math.min(recomputeIn, delayBeforeCheck);
                }
            } else {
                super.setActualState(state);
            }
            if (recomputeIn < Long.MAX_VALUE) {
                this.recomputeAfterDelay(recomputeIn);
            }
        }
    }

    protected String getExplanation(Lifecycle state) {
        Duration serviceFailedStabilizationDelay = (Duration)this.getConfig(ENTITY_FAILED_STABILIZATION_DELAY);
        Duration serviceRecoveredStabilizationDelay = (Duration)this.getConfig(ENTITY_RECOVERED_STABILIZATION_DELAY);
        return String.format("location=%s; status=%s; lastPublished=%s; timeNow=%s; currentFailurePeriod=%s; currentRecoveryPeriod=%s", new Object[]{this.entity.getLocations(), state != null ? state : "<unreported>", this.lastPublished, Time.makeDateString((long)System.currentTimeMillis()), (this.currentFailureStartTime != null ? this.getTimeStringSince(this.currentFailureStartTime) : "<none>") + " (stabilization " + Time.makeTimeStringRounded((Duration)serviceFailedStabilizationDelay) + ")", (this.currentRecoveryStartTime != null ? this.getTimeStringSince(this.currentRecoveryStartTime) : "<none>") + " (stabilization " + Time.makeTimeStringRounded((Duration)serviceRecoveredStabilizationDelay) + ")"});
    }

    private String getFailureDescription(long now) {
        String description = null;
        Map serviceProblems = (Map)this.entity.getAttribute(Attributes.SERVICE_PROBLEMS);
        if (serviceProblems != null && !serviceProblems.isEmpty()) {
            Map.Entry problem = serviceProblems.entrySet().iterator().next();
            description = (String)problem.getKey() + ": " + problem.getValue();
            description = serviceProblems.size() > 1 ? serviceProblems.size() + " service problems, including " + description : "service problem: " + description;
        } else {
            description = Boolean.FALSE.equals(this.entity.getAttribute(Attributes.SERVICE_UP)) ? "service not up" : "service failure detected";
        }
        if (this.publishEntityFailedTime != null && this.currentFailureStartTime != null && this.publishEntityFailedTime > this.currentFailureStartTime) {
            description = " (stabilized for " + Duration.of((long)(now - this.currentFailureStartTime), (TimeUnit)TimeUnit.MILLISECONDS) + ")";
        }
        return description;
    }

    protected void recomputeAfterDelay(long delay) {
        if (this.isRunning() && this.executorQueued.compareAndSet(false, true)) {
            long now = System.currentTimeMillis();
            delay = Math.max(0L, Math.max(delay, this.executorTime + 100L - now));
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} scheduling publish in {}ms", (Object)this, (Object)delay);
            }
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    try {
                        ServiceFailureDetector.this.executorTime = System.currentTimeMillis();
                        ServiceFailureDetector.this.executorQueued.set(false);
                        ServiceFailureDetector.this.onEvent(null);
                    }
                    catch (Exception e) {
                        if (ServiceFailureDetector.this.isRunning()) {
                            LOG.error("Error in enricher " + this + ": " + e, (Throwable)e);
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Error in enricher " + this + " (but no longer running): " + e, (Throwable)e);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("Error in enricher " + this + ": " + t, t);
                        throw Exceptions.propagate((Throwable)t);
                    }
                }
            };
            ScheduledTask task = new ScheduledTask((Map)MutableMap.of((Object)"delay", (Object)Duration.of((long)delay, (TimeUnit)TimeUnit.MILLISECONDS)), (Task)new BasicTask(job));
            ((EntityInternal)this.entity).getExecutionContext().submit((TaskAdaptable)task);
        }
    }

    private String getTimeStringSince(Long time) {
        return time == null ? null : Time.makeTimeStringRounded((long)(System.currentTimeMillis() - time));
    }

    public static enum LastPublished {
        NONE,
        FAILED,
        RECOVERED;

    }
}

