/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.ha;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.event.Sensor;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.event.basic.BasicNotificationSensor;
import brooklyn.policy.ha.AbstractFailureDetector;
import brooklyn.policy.ha.HASensors;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.guava.Maybe;
import brooklyn.util.net.Networking;
import brooklyn.util.time.Duration;
import com.google.common.net.HostAndPort;

@Catalog(name="Connection Failure Detector", description="HA policy for monitoring a host:port, emitting an event if the connection is lost/restored")
public class ConnectionFailureDetector
extends AbstractFailureDetector {
    public static final ConfigKey<HostAndPort> ENDPOINT = ConfigKeys.newConfigKey(HostAndPort.class, (String)"connectionFailureDetector.endpoint");
    public static final ConfigKey<Duration> POLL_PERIOD = ConfigKeys.newConfigKey(Duration.class, (String)"connectionFailureDetector.pollPeriod", (String)"", (Object)Duration.ONE_SECOND);
    public static final BasicNotificationSensor<HASensors.FailureDescriptor> CONNECTION_FAILED = HASensors.CONNECTION_FAILED;
    public static final BasicNotificationSensor<HASensors.FailureDescriptor> CONNECTION_RECOVERED = HASensors.CONNECTION_RECOVERED;
    @SetFromFlag(value="connectionFailedStabilizationDelay")
    public static final ConfigKey<Duration> CONNECTION_FAILED_STABILIZATION_DELAY = BasicConfigKey.builder(Duration.class).name("connectionFailureDetector.serviceFailedStabilizationDelay").description("Time period for which the connection must be consistently down for (e.g. doesn't report down-up-down) before concluding failure. Note that long TCP timeouts mean there can be long (e.g. 70 second) delays in noticing a connection refused condition.").defaultValue((Object)Duration.ZERO).build();
    @SetFromFlag(value="connectionRecoveredStabilizationDelay")
    public static final ConfigKey<Duration> CONNECTION_RECOVERED_STABILIZATION_DELAY = BasicConfigKey.builder(Duration.class).name("connectionFailureDetector.serviceRecoveredStabilizationDelay").description("For a failed connection, time period for which the connection must be consistently up for (e.g. doesn't report up-down-up) before concluding recovered").defaultValue((Object)Duration.ZERO).build();

    public void init() {
        super.init();
        this.getRequiredConfig(ENDPOINT);
        if (this.config().getRaw(SENSOR_FAILED).isAbsent()) {
            this.config().set(SENSOR_FAILED, CONNECTION_FAILED);
        }
        if (this.config().getRaw(SENSOR_RECOVERED).isAbsent()) {
            this.config().set(SENSOR_RECOVERED, CONNECTION_RECOVERED);
        }
    }

    @Override
    protected AbstractFailureDetector.CalculatedStatus calculateStatus() {
        HostAndPort endpoint = (HostAndPort)this.getConfig(ENDPOINT);
        boolean isHealthy = Networking.isReachable((HostAndPort)endpoint);
        return new AbstractFailureDetector.BasicCalculatedStatus(isHealthy, "endpoint=" + endpoint);
    }

    @Override
    protected Duration getPollPeriod() {
        return (Duration)this.getConfig(POLL_PERIOD);
    }

    @Override
    protected Duration getFailedStabilizationDelay() {
        return (Duration)this.getConfig(CONNECTION_FAILED_STABILIZATION_DELAY);
    }

    @Override
    protected Duration getRecoveredStabilizationDelay() {
        return (Duration)this.getConfig(CONNECTION_RECOVERED_STABILIZATION_DELAY);
    }

    @Override
    protected Sensor<HASensors.FailureDescriptor> getSensorFailed() {
        Maybe sensorFailed = this.config().getRaw(SENSOR_FAILED);
        if (sensorFailed.isPresent()) {
            return (Sensor)sensorFailed.get();
        }
        return CONNECTION_FAILED;
    }

    @Override
    protected Sensor<HASensors.FailureDescriptor> getSensorRecovered() {
        Maybe sensorRecovered = this.config().getRaw(SENSOR_RECOVERED);
        if (sensorRecovered.isPresent()) {
            return (Sensor)sensorRecovered.get();
        }
        return CONNECTION_RECOVERED;
    }
}

