/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.followthesun;

public class WeightedObject<T>
implements Comparable<WeightedObject<T>> {
    final T object;
    final double weight;

    public WeightedObject(T obj, double weight) {
        this.object = obj;
        this.weight = weight;
    }

    public T getObject() {
        return this.object;
    }

    public double getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(WeightedObject<T> o) {
        double diff = o.getWeight() - this.weight;
        if (diff > 1.0E-16) {
            return -1;
        }
        if (diff < -1.0E-16) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WeightedObject)) {
            return false;
        }
        if (this.getObject() == null) {
            return ((WeightedObject)obj).getObject() == null;
        }
        return this.getObject().equals(((WeightedObject)obj).getObject());
    }

    public int hashCode() {
        if (this.getObject() == null) {
            return 234519078;
        }
        return this.getObject().hashCode();
    }

    public String toString() {
        return "" + this.getObject() + "[" + this.getWeight() + "]";
    }
}

