/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.followthesun;

import brooklyn.entity.Entity;
import brooklyn.location.Location;
import brooklyn.policy.followthesun.DefaultFollowTheSunModel;
import brooklyn.policy.followthesun.FollowTheSunModel;
import brooklyn.policy.followthesun.FollowTheSunParameters;
import brooklyn.policy.followthesun.WeightedObject;
import brooklyn.policy.loadbalancing.Movable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowTheSunStrategy<ContainerType extends Entity, ItemType extends Movable> {
    private static final Logger LOG = LoggerFactory.getLogger(FollowTheSunStrategy.class);
    private final FollowTheSunParameters parameters;
    private final FollowTheSunModel<ContainerType, ItemType> model;
    private final String name;

    public FollowTheSunStrategy(FollowTheSunModel<ContainerType, ItemType> model, FollowTheSunParameters parameters) {
        this.model = model;
        this.parameters = parameters;
        this.name = model.getName();
    }

    public void rebalance() {
        try {
            Set<ItemType> items = this.model.getItems();
            Map<ItemType, Map<Location, Double>> directSendsToItemByLocation = this.model.getDirectSendsToItemByLocation();
            for (Movable item : items) {
                Double current;
                String itemName = this.model.getName(item);
                Location activeLocation = this.model.getItemLocation(item);
                Entity activeContainer = (Entity)this.model.getItemContainer(item);
                Map<Object, Double> sendsByLocation = directSendsToItemByLocation.get(item);
                if (sendsByLocation == null) {
                    sendsByLocation = Collections.emptyMap();
                }
                if (this.parameters.excludedLocations.contains(activeLocation)) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Ignoring segment {} as it is in {}", (Object)itemName, (Object)activeLocation);
                    continue;
                }
                if (!this.model.isItemMoveable(item)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("POLICY {} skipping any migration of {}, it is not moveable", (Object)this.name, (Object)itemName);
                    continue;
                }
                if (this.model.hasActiveMigration(item)) {
                    LOG.info("POLICY {} skipping any migration of {}, it is involved in an active migration already", (Object)this.name, (Object)itemName);
                    continue;
                }
                double total = DefaultFollowTheSunModel.sum(sendsByLocation.values());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("POLICY {} detected {} msgs/sec in {}, split up as: {}", new Object[]{this.name, total, itemName, sendsByLocation});
                }
                if ((current = sendsByLocation.get(activeLocation)) == null) {
                    current = 0.0;
                }
                ArrayList<WeightedObject<Location>> locationsWtd = new ArrayList<WeightedObject<Location>>();
                if (total > 0.0) {
                    for (Map.Entry<Object, Double> entry : sendsByLocation.entrySet()) {
                        Location l = (Location)entry.getKey();
                        Double d = entry.getValue();
                        if (!(d > current)) continue;
                        locationsWtd.add(new WeightedObject<Location>(l, d));
                    }
                }
                Collections.sort(locationsWtd);
                Collections.reverse(locationsWtd);
                double highestMsgRate = -1.0;
                Location highestLocation = null;
                Object optimalContainerInHighest = null;
                while (!locationsWtd.isEmpty()) {
                    WeightedObject weightedObject = (WeightedObject)locationsWtd.remove(0);
                    highestMsgRate = weightedObject.getWeight();
                    highestLocation = (Location)weightedObject.getObject();
                    optimalContainerInHighest = this.findOptimal(this.model.getAvailableContainersFor(item, highestLocation));
                    if (optimalContainerInHighest == null) continue;
                    break;
                }
                if (optimalContainerInHighest == null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("POLICY {} detected {} is already in optimal permitted location ({} of {} msgs/sec)", new Object[]{this.name, itemName, highestMsgRate, total});
                    continue;
                }
                double nextHighestMsgRate = -1.0;
                Object optimalContainerInNextHighest = null;
                while (!locationsWtd.isEmpty()) {
                    WeightedObject weightedObject = (WeightedObject)locationsWtd.remove(0);
                    nextHighestMsgRate = weightedObject.getWeight();
                    Location nextHighestLocation = (Location)weightedObject.getObject();
                    optimalContainerInNextHighest = this.findOptimal(this.model.getAvailableContainersFor(item, nextHighestLocation));
                    if (optimalContainerInNextHighest == null) continue;
                    break;
                }
                if (optimalContainerInNextHighest == null) {
                    nextHighestMsgRate = current;
                }
                if (this.parameters.isTriggered(highestMsgRate, total, nextHighestMsgRate, current)) {
                    LOG.info("POLICY " + this.name + " detected " + itemName + " should be in location " + highestLocation + " on " + optimalContainerInHighest + " (" + highestMsgRate + " of " + total + " msgs/sec), migrating");
                    try {
                        if (activeContainer.equals(optimalContainerInHighest)) {
                            LOG.warn("POLICY " + this.name + " detected " + itemName + " should move to " + optimalContainerInHighest + " (" + highestMsgRate + " of " + total + " msgs/sec) but it is already there with " + current + " msgs/sec");
                            continue;
                        }
                        item.move((Entity)optimalContainerInHighest);
                        this.model.onItemMoved(item, optimalContainerInHighest);
                    }
                    catch (Exception e) {
                        LOG.warn("POLICY " + this.name + " detected " + itemName + " should be on " + optimalContainerInHighest + ", but can't move it: " + e, (Throwable)e);
                    }
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("POLICY " + this.name + " detected " + itemName + " need not move to " + optimalContainerInHighest + " (" + highestMsgRate + " of " + total + " msgs/sec not much better than " + current + " at " + activeContainer + ")");
            }
        }
        catch (Exception e) {
            LOG.warn("Error in policy " + this.name + " (ignoring): " + e, (Throwable)e);
        }
    }

    private ContainerType findOptimal(Collection<ContainerType> contenders) {
        return (ContainerType)(contenders.isEmpty() ? null : (Entity)Iterables.get(contenders, (int)0));
    }
}

