/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.followthesun;

import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.Resizable;
import brooklyn.event.basic.BasicNotificationSensor;
import brooklyn.policy.followthesun.FollowTheSunPoolImpl;
import com.google.common.base.Preconditions;
import java.io.Serializable;

@ImplementedBy(value=FollowTheSunPoolImpl.class)
public interface FollowTheSunPool
extends Entity,
Resizable {
    public static final BasicNotificationSensor<Entity> CONTAINER_ADDED = new BasicNotificationSensor(Entity.class, "followthesun.container.added", "Container added");
    public static final BasicNotificationSensor<Entity> CONTAINER_REMOVED = new BasicNotificationSensor(Entity.class, "followthesun.container.removed", "Container removed");
    public static final BasicNotificationSensor<Entity> ITEM_ADDED = new BasicNotificationSensor(Entity.class, "followthesun.item.added", "Item added");
    public static final BasicNotificationSensor<Entity> ITEM_REMOVED = new BasicNotificationSensor(Entity.class, "followthesun.item.removed", "Item removed");
    public static final BasicNotificationSensor<ContainerItemPair> ITEM_MOVED = new BasicNotificationSensor(ContainerItemPair.class, "followthesun.item.moved", "Item moved to the given container");

    public void setContents(Group var1, Group var2);

    public Group getContainerGroup();

    public Group getItemGroup();

    public static class ContainerItemPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Entity container;
        public final Entity item;

        public ContainerItemPair(Entity container, Entity item) {
            this.container = container;
            this.item = (Entity)Preconditions.checkNotNull((Object)item);
        }

        public String toString() {
            return "" + this.item + " @ " + this.container;
        }
    }
}

