/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher;

import brooklyn.enricher.basic.AbstractTypeTransformingEnricher;
import brooklyn.entity.Entity;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeFractionDeltaEnricher<T extends Number>
extends AbstractTypeTransformingEnricher<T, Double> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeFractionDeltaEnricher.class);
    @SetFromFlag
    private long nanosPerOrigUnit;
    protected Number lastValue;
    protected long lastTimestamp = -1L;

    public TimeFractionDeltaEnricher() {
    }

    public TimeFractionDeltaEnricher(Entity producer, Sensor<T> source, Sensor<Double> target, TimeUnit origUnits) {
        this(producer, source, target, origUnits.toNanos(1L));
    }

    public TimeFractionDeltaEnricher(Entity producer, Sensor<T> source, Sensor<Double> target, long nanosPerOrigUnit) {
        super(producer, source, target);
        this.nanosPerOrigUnit = nanosPerOrigUnit;
        if (source != null && target != null) {
            this.uniqueTag = JavaClassNames.simpleClassName(((Object)((Object)this)).getClass()) + ":" + source.getName() + "*" + Duration.nanos((Number)nanosPerOrigUnit) + "->" + target.getName();
        }
    }

    public void onEvent(SensorEvent<T> event) {
        this.onEvent(event, event.getTimestamp());
    }

    public void onEvent(SensorEvent<T> event, long eventTimestamp) {
        Number current = (Number)event.getValue();
        if (current == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("ignoring null value in {}, at {}", new Object[]{this, eventTimestamp});
            }
            return;
        }
        if (eventTimestamp > this.lastTimestamp) {
            if (this.lastValue == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} received event but no last value so will not emit, null -> {} at {}", new Object[]{this, current, eventTimestamp});
                }
            } else if (this.lastTimestamp < 0L) {
                LOG.warn("{} has lastValue {} but last timestamp {}; new value is {} at {}; not publishing", new Object[]{this, this.lastValue, this.lastTimestamp, current, eventTimestamp});
            } else {
                long duration = eventTimestamp - this.lastTimestamp;
                double fraction = this.toNanos(current.doubleValue() - this.lastValue.doubleValue(), this.nanosPerOrigUnit) / (double)TimeUnit.MILLISECONDS.toNanos(duration);
                this.entity.setAttribute((AttributeSensor)this.target, (Object)fraction);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("set {} to {}, {} -> {} at {} (previous at {})", new Object[]{this, fraction, this.lastValue, current, eventTimestamp, this.lastTimestamp});
                }
            }
            this.lastValue = current;
            this.lastTimestamp = eventTimestamp;
        }
    }

    private double toNanos(double val, long nanosPerOrigUnit) {
        return val * (double)nanosPerOrigUnit;
    }
}

