/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.winrm;

import io.cloudsoft.winrm4j.pywinrm.Response;
import io.cloudsoft.winrm4j.pywinrm.Session;
import io.cloudsoft.winrm4j.pywinrm.WinRMFactory;
import io.cloudsoft.winrm4j.winrm.WinRmToolResponse;
import java.util.List;

public class WinRmTool {
    private final String address;
    private final String username;
    private final String password;
    private Session session;

    private WinRmTool(String address, String username, String password) {
        this.address = address;
        this.username = username;
        this.password = password;
        this.session = WinRMFactory.INSTANCE.createSession(address, username, password);
    }

    public static WinRmTool connect(String address, String username, String password) {
        WinRmTool tool = new WinRmTool(address, username, password);
        return tool;
    }

    public WinRmToolResponse executeScript(List<String> commands) {
        Response response = this.session.run_cmd(this.compileScript(commands), new String[0]);
        return this.responseToWinRmToolResponse(response);
    }

    public WinRmToolResponse executePs(List<String> commands) {
        Response response = this.session.run_ps(this.compileScript(commands));
        return this.responseToWinRmToolResponse(response);
    }

    private String compileScript(List<String> commands) {
        StringBuilder builder = new StringBuilder();
        for (String command : commands) {
            builder.append(command).append("\r\n");
        }
        return builder.toString();
    }

    private WinRmToolResponse responseToWinRmToolResponse(Response response) {
        return new WinRmToolResponse(response.getStdOut(), response.getStdErr(), response.getStatusCode());
    }
}

