/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.cli.lister;

import brooklyn.basic.BrooklynDynamicType;
import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynType;
import brooklyn.basic.BrooklynTypes;
import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.EntityType;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.event.Sensor;
import brooklyn.location.LocationResolver;
import brooklyn.rest.domain.SummaryComparators;
import brooklyn.rest.transform.EffectorTransformer;
import brooklyn.rest.transform.EntityTransformer;
import brooklyn.rest.transform.SensorTransformer;
import brooklyn.util.exceptions.RuntimeInterruptedException;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDescriptors {
    private static final Logger LOG = LoggerFactory.getLogger(ItemDescriptors.class);

    public static List<Map<String, Object>> toItemDescriptors(Iterable<? extends Class<? extends BrooklynObject>> types, boolean headingsOnly) {
        return ItemDescriptors.toItemDescriptors(types, headingsOnly, null);
    }

    public static List<Map<String, Object>> toItemDescriptors(Iterable<? extends Class<? extends BrooklynObject>> types, boolean headingsOnly, final String sortField) {
        ArrayList itemDescriptors = Lists.newArrayList();
        for (Class<? extends BrooklynObject> clazz : types) {
            try {
                Map<String, Object> itemDescriptor = ItemDescriptors.toItemDescriptor(clazz, headingsOnly);
                itemDescriptors.add(itemDescriptor);
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    throw new RuntimeInterruptedException((InterruptedException)throwable);
                }
                if (throwable instanceof RuntimeInterruptedException) {
                    throw (RuntimeInterruptedException)throwable;
                }
                LOG.warn("Could not load " + clazz + ": " + throwable);
            }
        }
        if (!Strings.isNullOrEmpty((String)sortField)) {
            Collections.sort(itemDescriptors, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> id1, Map<String, Object> id2) {
                    Object o1 = id1.get(sortField);
                    Object o2 = id2.get(sortField);
                    if (o1 == null) {
                        return o2 == null ? 0 : 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            });
        }
        return itemDescriptors;
    }

    public static Map<String, Object> toItemDescriptor(Class<? extends BrooklynObject> clazz, boolean headingsOnly) {
        Deprecated deprecatedAnnotation;
        Catalog catalogAnnotation;
        BrooklynDynamicType dynamicType = BrooklynTypes.getDefinedBrooklynType(clazz);
        BrooklynType type = dynamicType.getSnapshot();
        ConfigKey version = dynamicType.getConfigKey(BrooklynConfigKeys.SUGGESTED_VERSION.getName());
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.put("type", clazz.getName());
        if (version != null) {
            result.put("defaultVersion", version.getDefaultValue());
        }
        if ((catalogAnnotation = clazz.getAnnotation(Catalog.class)) != null) {
            result.put("name", catalogAnnotation.name());
            result.put("description", catalogAnnotation.description());
            result.put("iconUrl", catalogAnnotation.iconUrl());
        }
        if ((deprecatedAnnotation = clazz.getAnnotation(Deprecated.class)) != null) {
            result.put("deprecated", true);
        }
        if (!headingsOnly) {
            TreeSet config = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
            TreeSet sensors = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
            TreeSet effectors = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
            for (ConfigKey x : type.getConfigKeys()) {
                config.add(EntityTransformer.entityConfigSummary((ConfigKey)x, (Field)dynamicType.getConfigKeyField(x.getName())));
            }
            result.put("config", config);
            if (type instanceof EntityType) {
                for (ConfigKey x : ((EntityType)type).getSensors()) {
                    sensors.add(SensorTransformer.sensorSummaryForCatalog((Sensor)x));
                }
                result.put("sensors", sensors);
                for (ConfigKey x : ((EntityType)type).getEffectors()) {
                    effectors.add(EffectorTransformer.effectorSummaryForCatalog((Effector)x));
                }
                result.put("effectors", effectors);
            }
        }
        return result;
    }

    public static Object toItemDescriptors(List<LocationResolver> resolvers) {
        return ItemDescriptors.toItemDescriptors(resolvers, (Boolean)false);
    }

    public static Object toItemDescriptors(List<LocationResolver> resolvers, Boolean sort) {
        ArrayList result = Lists.newArrayList();
        for (LocationResolver resolver : resolvers) {
            result.add(ItemDescriptors.toItemDescriptor(resolver));
        }
        if (sort.booleanValue()) {
            Collections.sort(result, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    String s1 = o1 == null ? "" : o1.toString();
                    String s2 = o2 == null ? "" : o2.toString();
                    return s1.compareTo(s2);
                }
            });
        }
        return result;
    }

    public static Object toItemDescriptor(LocationResolver resolver) {
        return resolver.getPrefix();
    }
}

