/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.cli.lister;

import brooklyn.basic.BrooklynObject;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractApplication;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.util.ResourceUtils;
import brooklyn.util.javalang.UrlClassLoader;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFinder {
    private static final Logger log = LoggerFactory.getLogger(ClassFinder.class);
    private static final Collection<Class<?>> BORING = ImmutableList.of(Entity.class, AbstractEntity.class, SoftwareProcessImpl.class, Application.class, AbstractApplication.class, Policy.class, Enricher.class, AbstractPolicy.class, AbstractEnricher.class);

    public static Predicate<Class<?>> notBoring() {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input != null && !BORING.contains(input);
            }
        };
    }

    public static Predicate<Class<?>> withAnnotation(final Class<? extends Annotation> annotation) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input != null && input.getAnnotation(annotation) != null;
            }
        };
    }

    public static Predicate<? super Class<? extends BrooklynObject>> withClassNameMatching(final String typeRegex) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input != null && input.getName() != null && input.getName().matches(typeRegex);
            }
        };
    }

    @Beta
    public static List<URL> toJarUrls(String url) throws MalformedURLException {
        if (url == null) {
            throw new NullPointerException("Cannot read from null");
        }
        if (url == "") {
            throw new NullPointerException("Cannot read from empty string");
        }
        ArrayList result = Lists.newArrayList();
        String protocol = Urls.getProtocol((String)url);
        if (protocol != null) {
            if ("file".equals(protocol)) {
                url = ResourceUtils.tidyFileUrl((String)url);
            }
            result.add(new URL(url));
        } else {
            String tidiedPath = Os.tidyPath((String)url);
            File tidiedFile = new File(tidiedPath);
            if (tidiedFile.isDirectory()) {
                LinkedList toscan = Lists.newLinkedList();
                toscan.add(tidiedFile);
                while (toscan.size() > 0) {
                    File file = (File)toscan.remove(0);
                    if (file.isFile()) {
                        if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                        result.add(new URL("file://" + file.getAbsolutePath()));
                        continue;
                    }
                    if (file.isDirectory()) {
                        for (File subfile : file.listFiles()) {
                            toscan.add(subfile);
                        }
                        continue;
                    }
                    log.info("Cannot read " + file + "; not a file or directory");
                }
            } else {
                result.add(tidiedFile.toURI().toURL());
            }
        }
        return result;
    }

    public static <T extends BrooklynObject> Set<Class<? extends T>> findClasses(Collection<URL> urls, Class<T> clazz) {
        UrlClassLoader classLoader = new UrlClassLoader(urls.toArray(new URL[urls.size()]));
        Reflections reflections = new ConfigurationBuilder().addClassLoader((ClassLoader)classLoader).addScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner(), new FieldAnnotationsScanner()}).addUrls(urls).build();
        Set types = reflections.getSubTypesOf(clazz);
        return types;
    }
}

