/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.cli;

import brooklyn.basic.BrooklynObject;
import brooklyn.catalog.Catalog;
import brooklyn.cli.AbstractMain;
import brooklyn.cli.lister.ClassFinder;
import brooklyn.cli.lister.ItemDescriptors;
import brooklyn.entity.Entity;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.location.Location;
import brooklyn.location.LocationResolver;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.text.Strings;
import brooklyn.util.text.TemplateProcessor;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemLister {
    private static final Logger LOG = LoggerFactory.getLogger(ItemLister.class);
    private static final String BASE = "brooklyn/item-lister";
    private static final String BASE_TEMPLATES = "brooklyn/item-lister/templates";
    private static final String BASE_STATICS = "brooklyn/item-lister/statics";

    @Command(name="list-objects", description="List Brooklyn objects (Entities, Policies, Enrichers and Locations)")
    public static class ListAllCommand
    extends AbstractMain.BrooklynCommandCollectingArgs {
        @Option(name={"--jars"}, title="Jars", description="Jars to scan. If a file (not a url) pointing at a directory, will include all files in that directory")
        public List<String> jars = Lists.newLinkedList();
        @Option(name={"--type-regex"}, title="Regex for types to list")
        public String typeRegex;
        @Option(name={"--catalog-only"}, title="Whether to only list items annotated with @Catalog")
        public boolean catalogOnly = true;
        @Option(name={"--ignore-impls"}, title="Ignore Entity implementations, where there is an Entity interface with @ImplementedBy")
        public boolean ignoreImpls = false;
        @Option(name={"--headings-only"}, title="Whether to only show name/type, and not config keys etc")
        public boolean headingsOnly = false;
        @Option(name={"--output-folder"}, title="Folder to save output")
        public String outputFolder;
        int itemCount = 0;

        @Override
        public Void call() throws Exception {
            List<URL> urls = this.getUrls();
            LOG.info("Retrieving objects from " + urls);
            List<Class<Entity>> entityTypes = this.getTypes(urls, Entity.class);
            List<Class<Policy>> policyTypes = this.getTypes(urls, Policy.class);
            List<Class<Enricher>> enricherTypes = this.getTypes(urls, Enricher.class);
            List<Class<Location>> locationTypes = this.getTypes(urls, Location.class, Boolean.FALSE);
            ImmutableMap result = ImmutableMap.builder().put((Object)"entities", ItemDescriptors.toItemDescriptors(entityTypes, this.headingsOnly, "name")).put((Object)"policies", ItemDescriptors.toItemDescriptors(policyTypes, this.headingsOnly, "name")).put((Object)"enrichers", ItemDescriptors.toItemDescriptors(enricherTypes, this.headingsOnly, "name")).put((Object)"locations", ItemDescriptors.toItemDescriptors(locationTypes, this.headingsOnly, "type")).put((Object)"locationResolvers", ItemDescriptors.toItemDescriptors((List<LocationResolver>)ImmutableList.copyOf(ServiceLoader.load(LocationResolver.class)), (Boolean)true)).build();
            String json = this.toJson(result);
            if (this.outputFolder == null) {
                System.out.println(json);
            } else {
                LOG.info("Outputting item list (size " + this.itemCount + ") to " + this.outputFolder);
                String outputPath = Os.mergePaths((String[])new String[]{this.outputFolder, "index.html"});
                String parentDir = new File(outputPath).getParentFile().getAbsolutePath();
                this.mkdir(parentDir, "entities");
                this.mkdir(parentDir, "policies");
                this.mkdir(parentDir, "enrichers");
                this.mkdir(parentDir, "locations");
                this.mkdir(parentDir, "locationResolvers");
                this.mkdir(parentDir, "style");
                this.mkdir(Os.mergePaths((String[])new String[]{parentDir, "style"}), "js");
                this.mkdir(Os.mergePaths((String[])new String[]{parentDir, "style", "js"}), "catalog");
                Files.write((CharSequence)("var items = " + json), (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "items.js"})), (Charset)Charsets.UTF_8);
                ResourceUtils resourceUtils = ResourceUtils.create((Object)this);
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "brooklyn-object-list.html", "index.html");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "common.js");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "items.css");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "style/js/underscore-min.js");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "style/js/underscore-min.map");
                this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, "style/js/catalog/bloodhound.js");
                List entities = (List)result.get("entities");
                String entityTemplateHtml = resourceUtils.getResourceAsString(Urls.mergePaths((String[])new String[]{ItemLister.BASE_TEMPLATES, "entity.html"}));
                for (Map entity : entities) {
                    String type = (String)entity.get("type");
                    String name = (String)entity.get("name");
                    String entityHtml = TemplateProcessor.processTemplateContents((String)entityTemplateHtml, (Map)ImmutableMap.of((Object)"type", (Object)type, (Object)"name", (Object)name));
                    Files.write((CharSequence)entityHtml, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "entities", type + ".html"})), (Charset)Charsets.UTF_8);
                }
                List policies = (List)result.get("policies");
                String policyTemplateHtml = resourceUtils.getResourceAsString(Urls.mergePaths((String[])new String[]{ItemLister.BASE_TEMPLATES, "policy.html"}));
                for (Map policy : policies) {
                    String type = (String)policy.get("type");
                    String name = (String)policy.get("name");
                    String policyHtml = TemplateProcessor.processTemplateContents((String)policyTemplateHtml, (Map)ImmutableMap.of((Object)"type", (Object)type, (Object)"name", (Object)name));
                    Files.write((CharSequence)policyHtml, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "policies", type + ".html"})), (Charset)Charsets.UTF_8);
                }
                List enrichers = (List)result.get("enrichers");
                String enricherTemplateHtml = resourceUtils.getResourceAsString(Urls.mergePaths((String[])new String[]{ItemLister.BASE_TEMPLATES, "enricher.html"}));
                for (Map enricher : enrichers) {
                    String type = (String)enricher.get("type");
                    String name = (String)enricher.get("name");
                    String enricherHtml = TemplateProcessor.processTemplateContents((String)enricherTemplateHtml, (Map)ImmutableMap.of((Object)"type", (Object)type, (Object)"name", (Object)name));
                    Files.write((CharSequence)enricherHtml, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "enrichers", type + ".html"})), (Charset)Charsets.UTF_8);
                }
                List locations = (List)result.get("locations");
                String locationTemplateHtml = resourceUtils.getResourceAsString(Urls.mergePaths((String[])new String[]{ItemLister.BASE_TEMPLATES, "location.html"}));
                for (Map location : locations) {
                    String type = (String)location.get("type");
                    String locationHtml = TemplateProcessor.processTemplateContents((String)locationTemplateHtml, (Map)ImmutableMap.of((Object)"type", (Object)type));
                    Files.write((CharSequence)locationHtml, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, "locations", type + ".html"})), (Charset)Charsets.UTF_8);
                }
                LOG.info("Finished outputting item list to " + this.outputFolder);
            }
            return null;
        }

        private void copyFromItemListerClasspathBaseStaticsToOutputDir(ResourceUtils resourceUtils, String item) throws IOException {
            this.copyFromItemListerClasspathBaseStaticsToOutputDir(resourceUtils, item, item);
        }

        private void copyFromItemListerClasspathBaseStaticsToOutputDir(ResourceUtils resourceUtils, String item, String dest) throws IOException {
            String js = resourceUtils.getResourceAsString(Urls.mergePaths((String[])new String[]{ItemLister.BASE_STATICS, item}));
            Files.write((CharSequence)js, (File)new File(Os.mergePaths((String[])new String[]{this.outputFolder, dest})), (Charset)Charsets.UTF_8);
        }

        private void mkdir(String rootDir, String dirName) {
            new File(Os.mergePaths((String[])new String[]{rootDir, dirName})).mkdirs();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected List<URL> getUrls() throws MalformedURLException {
            ArrayList urls = Lists.newArrayList();
            if (this.jars.isEmpty()) {
                String classpath = System.getenv("INITIAL_CLASSPATH");
                if (!Strings.isNonBlank((CharSequence)classpath)) throw new IllegalArgumentException("No Jars to process");
                List entries = Splitter.on((String)":").omitEmptyStrings().trimResults().splitToList((CharSequence)classpath);
                for (String entry : entries) {
                    if (!entry.endsWith(".jar") && !entry.endsWith("/*")) continue;
                    urls.addAll(ClassFinder.toJarUrls(entry.replace("/*", "")));
                }
                return urls;
            } else {
                for (String jar : this.jars) {
                    List<URL> expanded = ClassFinder.toJarUrls(jar);
                    if (expanded.isEmpty()) {
                        LOG.warn("No jars found at: " + jar);
                    }
                    urls.addAll(expanded);
                }
            }
            return urls;
        }

        private <T extends BrooklynObject> List<Class<? extends T>> getTypes(List<URL> urls, Class<T> type) {
            return this.getTypes(urls, type, null);
        }

        private <T extends BrooklynObject> List<Class<? extends T>> getTypes(List<URL> urls, Class<T> type, Boolean catalogOnlyOverride) {
            ImmutableList result;
            FluentIterable fluent = FluentIterable.from(ClassFinder.findClasses(urls, type));
            if (this.typeRegex != null) {
                fluent = fluent.filter(ClassFinder.withClassNameMatching(this.typeRegex));
            }
            if (catalogOnlyOverride == null ? this.catalogOnly : catalogOnlyOverride != false) {
                fluent = fluent.filter(ClassFinder.withAnnotation(Catalog.class));
            }
            ImmutableList filtered = fluent.toList();
            if (this.ignoreImpls) {
                result = MutableSet.copyOf((Iterable)filtered);
                for (Class clazz : filtered) {
                    ImplementedBy implementedBy = clazz.getAnnotation(ImplementedBy.class);
                    if (implementedBy == null) continue;
                    result.remove(implementedBy.value());
                }
            } else {
                result = filtered;
            }
            this.itemCount += result.size();
            return ImmutableList.copyOf((Collection)result);
        }

        private String toJson(Object obj) throws JsonProcessingException {
            ObjectMapper objectMapper = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS).enable(SerializationFeature.INDENT_OUTPUT).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).setSerializationInclusion(JsonInclude.Include.ALWAYS).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            return objectMapper.writeValueAsString(obj);
        }
    }
}

