/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.cli;

import brooklyn.cli.AbstractMain;
import brooklyn.location.LocationDefinition;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsUtil;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import brooklyn.util.stream.Streams;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.airlift.command.ParseException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;

public class CloudExplorer {

    @Command(name="blob", description="")
    public static class BlobstoreGetBlobCommand
    extends BlobstoreCommand {
        @Option(name={"--container"}, title="list contents of a given container", description="")
        public String container;
        @Option(name={"--blob"}, title="retrieves the blog in the given container", description="")
        public String blob;

        @Override
        protected void doCall(BlobStore blobStore, String indent) throws Exception {
            this.failIfArguments();
            Blob content = blobStore.getBlob(this.container, this.blob);
            this.stdout.println(indent + "Blob " + this.container + " : " + this.blob + " {");
            this.stdout.println(indent + "\tHeaders {");
            for (Map.Entry entry : content.getAllHeaders().entries()) {
                this.stdout.println(indent + "\t\t" + (String)entry.getKey() + " = " + (String)entry.getValue());
            }
            this.stdout.println(indent + "\t}");
            this.stdout.println(indent + "\tmetadata : " + content.getMetadata());
            this.stdout.println(indent + "\tpayload : " + Streams.readFullyString((InputStream)content.getPayload().openStream()));
            this.stdout.println(indent + "}");
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("container", (Object)this.container).add("blob", (Object)this.blob);
        }
    }

    @Command(name="list-container", description="")
    public static class BlobstoreListContainerCommand
    extends BlobstoreCommand {
        @Override
        protected void doCall(BlobStore blobStore, String indent) throws Exception {
            if (this.arguments.isEmpty()) {
                throw new ParseException("Requires at least one container-name arguments", new Object[0]);
            }
            for (String containerName : this.arguments) {
                PageSet contents = blobStore.list(containerName);
                this.stdout.println(indent + "Container " + containerName + " {");
                for (StorageMetadata content : contents) {
                    this.stdout.println(indent + "\t" + content);
                }
                this.stdout.println(indent + "}");
            }
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("containers", (Object)this.arguments);
        }
    }

    @Command(name="list-containers", description="")
    public static class BlobstoreListContainersCommand
    extends BlobstoreCommand {
        @Override
        protected void doCall(BlobStore blobstore, String indent) throws Exception {
            this.failIfArguments();
            PageSet containers = blobstore.list();
            this.stdout.println(indent + "Containers {");
            for (StorageMetadata container : containers) {
                this.stdout.println(indent + "\t" + container);
            }
            this.stdout.println(indent + "}");
        }
    }

    public static abstract class BlobstoreCommand
    extends JcloudsCommand {
        protected abstract void doCall(BlobStore var1, String var2) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doCall(JcloudsLocation loc, String indent) throws Exception {
            String identity = (String)Preconditions.checkNotNull((Object)loc.getConfig(LocationConfigKeys.ACCESS_IDENTITY), (Object)"identity must not be null");
            String credential = (String)Preconditions.checkNotNull((Object)loc.getConfig(LocationConfigKeys.ACCESS_CREDENTIAL), (Object)"credential must not be null");
            String provider = (String)Preconditions.checkNotNull((Object)loc.getConfig(LocationConfigKeys.CLOUD_PROVIDER), (Object)"provider must not be null");
            String endpoint = (String)loc.getConfig(CloudLocationConfig.CLOUD_ENDPOINT);
            BlobStoreContext context = JcloudsUtil.newBlobstoreContext((String)provider, (String)endpoint, (String)identity, (String)credential);
            try {
                BlobStore blobStore = context.getBlobStore();
                this.doCall(blobStore, indent);
            }
            finally {
                context.close();
            }
        }
    }

    @Command(name="terminate-instances", description="")
    public static class ComputeTerminateInstancesCommand
    extends ComputeCommand {
        @Override
        protected void doCall(ComputeService computeService, String indent) throws Exception {
            if (this.arguments.isEmpty()) {
                throw new ParseException("Requires at least one instance-id arguments", new Object[0]);
            }
            for (String instanceId : this.arguments) {
                NodeMetadata instance = computeService.getNodeMetadata(instanceId);
                if (instance == null) {
                    this.stderr.println(indent + "Cannot terminate instance; could not find " + instanceId);
                    continue;
                }
                boolean confirmed = this.confirm(indent, "terminate " + instanceId + " (" + instance + ")");
                if (!confirmed) continue;
                computeService.destroyNode(instanceId);
            }
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("instanceIds", (Object)this.arguments);
        }
    }

    @Command(name="default-template", description="")
    public static class ComputeDefaultTemplateCommand
    extends JcloudsCommand {
        @Override
        protected void doCall(JcloudsLocation loc, String indent) throws Exception {
            this.failIfArguments();
            ComputeService computeService = loc.getComputeService();
            Template template = loc.buildTemplate(computeService, loc.config().getBag());
            Image image = template.getImage();
            Hardware hardware = template.getHardware();
            Location location = template.getLocation();
            TemplateOptions options = template.getOptions();
            this.stdout.println(indent + "Default template {");
            this.stdout.println(indent + "\tImage: " + image);
            this.stdout.println(indent + "\tHardware: " + hardware);
            this.stdout.println(indent + "\tLocation: " + location);
            this.stdout.println(indent + "\tOptions: " + options);
            this.stdout.println(indent + "}");
        }
    }

    @Command(name="get-image", description="")
    public static class ComputeGetImageCommand
    extends ComputeCommand {
        @Override
        protected void doCall(ComputeService computeService, String indent) throws Exception {
            if (this.arguments.isEmpty()) {
                throw new ParseException("Requires at least one image-id arguments", new Object[0]);
            }
            for (String imageId : this.arguments) {
                Image image = computeService.getImage(imageId);
                this.stdout.println(indent + "Image " + imageId + " {");
                this.stdout.println(indent + "\t" + image);
                this.stdout.println(indent + "}");
            }
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("imageIds", (Object)this.arguments);
        }
    }

    @Command(name="list-hardware-profiles", description="")
    public static class ComputeListHardwareProfilesCommand
    extends ComputeCommand {
        @Override
        protected void doCall(ComputeService computeService, String indent) throws Exception {
            this.failIfArguments();
            Set hardware = computeService.listHardwareProfiles();
            this.stdout.println(indent + "Hardware Profiles {");
            for (Hardware image : hardware) {
                this.stdout.println(indent + "\t" + image);
            }
            this.stdout.println(indent + "}");
        }
    }

    @Command(name="list-images", description="")
    public static class ComputeListImagesCommand
    extends ComputeCommand {
        @Override
        protected void doCall(ComputeService computeService, String indent) throws Exception {
            this.failIfArguments();
            Set images = computeService.listImages();
            this.stdout.println(indent + "Images {");
            for (Image image : images) {
                this.stdout.println(indent + "\t" + image);
            }
            this.stdout.println(indent + "}");
        }
    }

    @Command(name="list-instances", description="")
    public static class ComputeListInstancesCommand
    extends ComputeCommand {
        @Override
        protected void doCall(ComputeService computeService, String indent) throws Exception {
            this.failIfArguments();
            Set instances = computeService.listNodes();
            this.stdout.println(indent + "Instances {");
            for (ComputeMetadata instance : instances) {
                this.stdout.println(indent + "\t" + instance);
            }
            this.stdout.println(indent + "}");
        }
    }

    public static abstract class ComputeCommand
    extends JcloudsCommand {
        protected abstract void doCall(ComputeService var1, String var2) throws Exception;

        @Override
        protected void doCall(JcloudsLocation loc, String indent) throws Exception {
            ComputeService computeService = loc.getComputeService();
            this.doCall(computeService, indent);
        }
    }

    public static abstract class JcloudsCommand
    extends AbstractMain.BrooklynCommandCollectingArgs {
        @Option(name={"--all-locations"}, title="all locations", description="All locations (i.e. all locations in brooklyn.properties for which there are credentials)")
        public boolean allLocations;
        @Option(name={"-l", "--location"}, title="location spec", description="A location spec (e.g. referring to a named location in brooklyn.properties file)")
        public String location;
        @Option(name={"-y", "--yes"}, title="auto-confirm", description="Automatically answer yes to any questions")
        public boolean autoconfirm = false;

        protected abstract void doCall(JcloudsLocation var1, String var2) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            LocalManagementContext mgmt = new LocalManagementContext();
            ArrayList locs = Lists.newArrayList();
            try {
                if (this.location != null && this.allLocations) {
                    throw new FatalConfigurationRuntimeException("Must not specify --location and --all-locations");
                }
                if (this.location != null) {
                    JcloudsLocation loc = (JcloudsLocation)mgmt.getLocationRegistry().resolve(this.location);
                    locs.add(loc);
                } else if (this.allLocations) {
                    Map definedLocations = mgmt.getLocationRegistry().getDefinedLocations();
                    for (LocationDefinition locationDef : definedLocations.values()) {
                        brooklyn.location.Location loc = mgmt.getLocationRegistry().resolve(locationDef);
                        if (!(loc instanceof JcloudsLocation)) continue;
                        boolean found = false;
                        for (JcloudsLocation existing : locs) {
                            if (!this.equalTargets(existing, (JcloudsLocation)loc)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        locs.add((JcloudsLocation)loc);
                    }
                } else {
                    throw new FatalConfigurationRuntimeException("Must specify one of --location or --all-locations");
                }
                for (JcloudsLocation loc : locs) {
                    this.stdout.println("Location {");
                    this.stdout.println("\tprovider: " + loc.getProvider());
                    this.stdout.println("\tdisplayName: " + loc.getDisplayName());
                    this.stdout.println("\tidentity: " + loc.getIdentity());
                    if (loc.getEndpoint() != null) {
                        this.stdout.println("\tendpoint: " + loc.getEndpoint());
                    }
                    if (loc.getRegion() != null) {
                        this.stdout.println("\tregion: " + loc.getRegion());
                    }
                    try {
                        this.doCall(loc, "\t");
                    }
                    finally {
                        this.stdout.println("}");
                    }
                }
            }
            finally {
                mgmt.terminate();
            }
            return null;
        }

        @Override
        public Objects.ToStringHelper string() {
            return super.string().add("location", (Object)this.location);
        }

        protected boolean equalTargets(JcloudsLocation loc1, JcloudsLocation loc2) {
            return Objects.equal((Object)loc1.getProvider(), (Object)loc2.getProvider()) && Objects.equal((Object)loc1.getIdentity(), (Object)loc2.getIdentity()) && Objects.equal((Object)loc1.getEndpoint(), (Object)loc2.getEndpoint()) && Objects.equal((Object)loc1.getRegion(), (Object)loc2.getRegion());
        }

        protected boolean confirm(String msg, String indent) throws Exception {
            boolean confirmed;
            if (this.autoconfirm) {
                this.stdout.println(indent + "Auto-confirmed: " + msg);
                return true;
            }
            this.stdout.println(indent + "Enter y/n. Are you sure you want to " + msg);
            int in = this.stdin.read();
            boolean bl = confirmed = Character.toLowerCase(in) == 121;
            if (confirmed) {
                this.stdout.println(indent + "Confirmed; will " + msg);
            } else {
                this.stdout.println(indent + "Declined; will not " + msg);
            }
            return confirmed;
        }
    }
}

