/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.jmx.jmxrmi;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class JmxRmiAgent {
    public static final String RMI_REGISTRY_PORT_PROPERTY = "brooklyn.jmx-agent.rmi-port";
    public static final String RMI_REGISTRY_DEFAULT_PORT = "9001";
    public static final String JMX_SERVER_PORT_PROPERTY = "brooklyn.jmx-agent.jmx-port";
    public static final String JMX_SERVER_DEFAULT_PORT = "11099";
    public static final String RMI_HOSTNAME_PROPERTY = "java.rmi.server.hostname";
    public static final String JMX_SERVER_ADDRESS_WILDCARD_PROPERTY = "jmx.remote.server.address.wildcard";

    public static void premain(String agentArgs) {
        JmxRmiAgent.doMain(agentArgs);
    }

    public static void agentmain(String agentArgs) {
        JmxRmiAgent.doMain(agentArgs);
    }

    public static void doMain(final String agentArgs) {
        Thread t = new Thread(){

            @Override
            public void run() {
                JmxRmiAgent.doMainForeground(agentArgs);
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static void doMainForeground(String agentArgs) {
        final JMXConnectorServer connector = new JmxRmiAgent().startServer(System.getProperties());
        if (connector != null) {
            Runtime.getRuntime().addShutdownHook(new Thread("jmxrmi-agent-shutdownHookThread"){

                @Override
                public void run() {
                    try {
                        connector.stop();
                    }
                    catch (Exception e) {
                        System.err.println("Error closing jmxrmi connector in shutdown hook (continuing): " + e);
                    }
                }
            });
        }
    }

    public JMXConnectorServer startServer(Properties properties) {
        try {
            System.setProperty("java.rmi.server.randomIDs", "true");
            int rmiPort = Integer.parseInt(System.getProperty(RMI_REGISTRY_PORT_PROPERTY, RMI_REGISTRY_DEFAULT_PORT));
            int jmxPort = Integer.parseInt(System.getProperty(JMX_SERVER_PORT_PROPERTY, JMX_SERVER_DEFAULT_PORT));
            String hostname = this.getLocalhostHostname(properties);
            System.out.println("Setting up JmxRmiAgent for: " + hostname + " " + rmiPort + " / " + jmxPort);
            LocateRegistry.createRegistry(rmiPort);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            LinkedHashMap<String, Object> env = new LinkedHashMap<String, Object>();
            JmxRmiAgent.propagate(properties, env, JMX_SERVER_ADDRESS_WILDCARD_PROPERTY, "true");
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + hostname + ":" + jmxPort + "/jndi/rmi://" + hostname + ":" + rmiPort + "/jmxrmi");
            JMXConnectorServer connector = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            connector.start();
            System.out.println("JmxRmiAgent JMXConnectorServer active at: " + url);
            return connector;
        }
        catch (RuntimeException e) {
            System.err.println("Unable to start JMXConnectorServer: " + e);
            throw e;
        }
        catch (Exception e) {
            System.err.println("Unable to start JMXConnectorServer: " + e);
            throw new RuntimeException(e);
        }
    }

    private static boolean propagate(Properties source, Map<String, Object> target, String key, Object defaultValueIfNotNull) {
        Object v = source.getProperty(key);
        if (v == null) {
            v = defaultValueIfNotNull;
        }
        if (v == null) {
            return false;
        }
        target.put(key, v);
        return true;
    }

    private String getLocalhostHostname(Properties properties) throws UnknownHostException {
        String hostname;
        String string = hostname = properties == null ? null : properties.getProperty(RMI_HOSTNAME_PROPERTY);
        if ("0.0.0.0".equals(hostname)) {
            System.err.println("WARN: invalid hostname 0.0.0.0 specified for JmxRmiAgent; it typically must be an address or hostname which is bindable on the machine where this service is running AND accessible by a client machine (access will likely be impossible)");
        }
        if (hostname == null || hostname.isEmpty()) {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        return hostname;
    }

    public static void main(String[] args) throws Exception {
        JmxRmiAgent.premain("");
    }
}

