/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.blobstore.LocalStorageStrategy;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.reference.BlobStoreConstants;
import org.jclouds.domain.Location;
import org.jclouds.filesystem.predicates.validators.FilesystemBlobKeyValidator;
import org.jclouds.filesystem.predicates.validators.FilesystemContainerNameValidator;
import org.jclouds.filesystem.util.Utils;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.util.Closeables2;

public class FilesystemStorageStrategyImpl
implements LocalStorageStrategy {
    private static final String XATTR_CONTENT_DISPOSITION = "user.content-disposition";
    private static final String XATTR_CONTENT_ENCODING = "user.content-encoding";
    private static final String XATTR_CONTENT_LANGUAGE = "user.content-language";
    private static final String XATTR_CONTENT_MD5 = "user.content-md5";
    private static final String XATTR_CONTENT_TYPE = "user.content-type";
    private static final String XATTR_EXPIRES = "user.expires";
    private static final String XATTR_USER_METADATA_PREFIX = "user.user-metadata.";
    private static final byte[] DIRECTORY_MD5 = Hashing.md5().hashBytes(new byte[0]).asBytes();
    private static final String BACK_SLASH = "\\";
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Provider<BlobBuilder> blobBuilders;
    protected final String baseDirectory;
    protected final FilesystemContainerNameValidator filesystemContainerNameValidator;
    protected final FilesystemBlobKeyValidator filesystemBlobKeyValidator;

    @Inject
    protected FilesystemStorageStrategyImpl(Provider<BlobBuilder> blobBuilders, @Named(value="jclouds.filesystem.basedir") String baseDir, FilesystemContainerNameValidator filesystemContainerNameValidator, FilesystemBlobKeyValidator filesystemBlobKeyValidator) {
        this.blobBuilders = (Provider)Preconditions.checkNotNull(blobBuilders, (Object)"filesystem storage strategy blobBuilders");
        this.baseDirectory = (String)Preconditions.checkNotNull((Object)baseDir, (Object)"filesystem storage strategy base directory");
        this.filesystemContainerNameValidator = (FilesystemContainerNameValidator)((Object)Preconditions.checkNotNull((Object)((Object)filesystemContainerNameValidator), (Object)"filesystem container name validator"));
        this.filesystemBlobKeyValidator = (FilesystemBlobKeyValidator)((Object)Preconditions.checkNotNull((Object)((Object)filesystemBlobKeyValidator), (Object)"filesystem blob key validator"));
    }

    public boolean containerExists(String container) {
        this.filesystemContainerNameValidator.validate(container);
        return this.directoryExists(container, null);
    }

    public Iterable<String> getAllContainerNames() {
        File[] files = new File(this.buildPathStartingFromBaseDir(new String[0])).listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder containers = ImmutableList.builder();
        for (File file : files) {
            if (!file.isDirectory()) continue;
            containers.add((Object)file.getName());
        }
        return containers.build();
    }

    public boolean createContainerInLocation(String container, Location location) {
        this.logger.debug("Creating container %s", new Object[]{container});
        this.filesystemContainerNameValidator.validate(container);
        return this.createDirectoryWithResult(container, null);
    }

    public void deleteContainer(String container) {
        this.filesystemContainerNameValidator.validate(container);
        if (!this.containerExists(container)) {
            return;
        }
        this.deleteDirectory(container, null);
    }

    public void clearContainer(String container) {
        this.clearContainer(container, ListContainerOptions.Builder.recursive());
    }

    public void clearContainer(String container, ListContainerOptions options) {
        this.filesystemContainerNameValidator.validate(container);
        if (options.getDir() != null) {
            container = container + FilesystemStorageStrategyImpl.denormalize("/" + options.getDir());
        }
        try {
            File containerFile = this.openFolder(container);
            File[] children = containerFile.listFiles();
            if (null != children) {
                for (File child : children) {
                    if (!options.isRecursive() && !child.isFile()) continue;
                    Utils.deleteRecursively(child);
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "An error occurred while clearing container %s", new Object[]{container});
            Throwables.propagate((Throwable)e);
        }
    }

    public StorageMetadata getContainerMetadata(String container) {
        BasicFileAttributes attr;
        MutableStorageMetadataImpl metadata = new MutableStorageMetadataImpl();
        metadata.setName(container);
        metadata.setType((Enum)StorageType.CONTAINER);
        metadata.setLocation(this.getLocation(container));
        Path path = new File(this.buildPathStartingFromBaseDir(container)).toPath();
        try {
            attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        metadata.setCreationDate(new Date(attr.creationTime().toMillis()));
        return metadata;
    }

    public boolean blobExists(String container, String key) {
        this.filesystemContainerNameValidator.validate(container);
        this.filesystemBlobKeyValidator.validate(key);
        try {
            return this.buildPathAndChecksIfBlobExists(container, key);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "An error occurred while checking key %s in container %s", new Object[]{container, key});
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Iterable<String> getBlobKeysInsideContainer(String container) throws IOException {
        this.filesystemContainerNameValidator.validate(container);
        HashSet blobNames = Sets.newHashSet();
        if (!this.containerExists(container)) {
            return blobNames;
        }
        File containerFile = this.openFolder(container);
        final int containerPathLength = containerFile.getAbsolutePath().length() + 1;
        FilesystemStorageStrategyImpl.populateBlobKeysInContainer(containerFile, blobNames, new Function<String, String>(){

            public String apply(String string) {
                return string.substring(containerPathLength);
            }
        });
        return blobNames;
    }

    public Blob getBlob(String container, String key) {
        ByteSource byteSource;
        BlobBuilder builder = (BlobBuilder)this.blobBuilders.get();
        builder.name(key);
        File file = this.getFileForBlobKey(container, key);
        Path path = file.toPath();
        if (FilesystemStorageStrategyImpl.getDirectoryBlobSuffix(key) != null) {
            this.logger.debug("%s - %s is a directory", new Object[]{container, key});
            byteSource = ByteSource.empty();
        } else {
            byteSource = com.google.common.io.Files.asByteSource((File)file);
        }
        try {
            String contentDisposition = null;
            String contentEncoding = null;
            String contentLanguage = null;
            String contentType = null;
            HashCode hashCode = null;
            Date expires = null;
            ImmutableMap.Builder userMetadata = ImmutableMap.builder();
            UserDefinedFileAttributeView view = this.getUserDefinedFileAttributeView(file.toPath());
            if (view != null) {
                ByteBuffer buf;
                ImmutableSet attributes = ImmutableSet.copyOf(view.list());
                contentDisposition = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, XATTR_CONTENT_DISPOSITION);
                contentEncoding = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, XATTR_CONTENT_ENCODING);
                contentLanguage = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, XATTR_CONTENT_LANGUAGE);
                contentType = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, XATTR_CONTENT_TYPE);
                if (attributes.contains(XATTR_CONTENT_MD5)) {
                    buf = ByteBuffer.allocate(view.size(XATTR_CONTENT_MD5));
                    view.read(XATTR_CONTENT_MD5, buf);
                    hashCode = HashCode.fromBytes((byte[])buf.array());
                }
                if (attributes.contains(XATTR_EXPIRES)) {
                    buf = ByteBuffer.allocate(view.size(XATTR_EXPIRES));
                    view.read(XATTR_EXPIRES, buf);
                    buf.flip();
                    expires = new Date(buf.asLongBuffer().get());
                }
                for (String attribute : attributes) {
                    if (!attribute.startsWith(XATTR_USER_METADATA_PREFIX)) continue;
                    String value = FilesystemStorageStrategyImpl.readStringAttributeIfPresent(view, (Set<String>)attributes, attribute);
                    userMetadata.put((Object)attribute.substring(XATTR_USER_METADATA_PREFIX.length()), (Object)value);
                }
                builder.payload(byteSource).contentDisposition(contentDisposition).contentEncoding(contentEncoding).contentLanguage(contentLanguage).contentLength(byteSource.size()).contentMD5(hashCode).contentType(contentType).expires(expires).userMetadata((Map)userMetadata.build());
            } else {
                builder.payload(byteSource).contentLength(byteSource.size()).contentMD5(byteSource.hash(Hashing.md5()).asBytes());
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Blob blob = builder.build();
        blob.getMetadata().setContainer(container);
        blob.getMetadata().setLastModified(new Date(file.lastModified()));
        blob.getMetadata().setSize(Long.valueOf(file.length()));
        if (blob.getPayload().getContentMetadata().getContentMD5() != null) {
            blob.getMetadata().setETag(BaseEncoding.base16().lowerCase().encode(blob.getPayload().getContentMetadata().getContentMD5()));
        }
        return blob;
    }

    private void writeCommonMetadataAttr(UserDefinedFileAttributeView view, Blob blob) throws IOException {
        MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_CONTENT_DISPOSITION, metadata.getContentDisposition());
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_CONTENT_ENCODING, metadata.getContentEncoding());
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_CONTENT_LANGUAGE, metadata.getContentLanguage());
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_CONTENT_TYPE, metadata.getContentType());
        Date expires = metadata.getExpires();
        if (expires != null) {
            ByteBuffer buf = ByteBuffer.allocate(8).putLong(expires.getTime());
            buf.flip();
            view.write(XATTR_EXPIRES, buf);
        }
        for (Map.Entry entry : blob.getMetadata().getUserMetadata().entrySet()) {
            FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, XATTR_USER_METADATA_PREFIX + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private String putDirectoryBlob(String containerName, Blob blob) throws IOException {
        String blobKey = blob.getMetadata().getName();
        MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
        Long contentLength = metadata.getContentLength();
        if (contentLength != null && contentLength != 0L) {
            throw new IllegalArgumentException("Directory blob cannot have content: " + blobKey);
        }
        File outputFile = this.getFileForBlobKey(containerName, blobKey);
        Path outputPath = outputFile.toPath();
        if (!outputFile.isDirectory() && !outputFile.mkdirs()) {
            throw new IOException("Unable to mkdir: " + outputPath);
        }
        UserDefinedFileAttributeView view = this.getUserDefinedFileAttributeView(outputPath);
        if (view != null) {
            try {
                view.write(XATTR_CONTENT_MD5, ByteBuffer.wrap(DIRECTORY_MD5));
                this.writeCommonMetadataAttr(view, blob);
            }
            catch (IOException e) {
                this.logger.debug("xattrs not supported on %s", new Object[]{outputPath});
            }
        } else {
            this.logger.warn("xattr not supported on %s", new Object[]{blobKey});
        }
        return BaseEncoding.base16().lowerCase().encode(DIRECTORY_MD5);
    }

    public String putBlob(String containerName, Blob blob) throws IOException {
        String string;
        String blobKey = blob.getMetadata().getName();
        Payload payload = blob.getPayload();
        this.filesystemContainerNameValidator.validate(containerName);
        this.filesystemBlobKeyValidator.validate(blobKey);
        if (FilesystemStorageStrategyImpl.getDirectoryBlobSuffix(blobKey) != null) {
            return this.putDirectoryBlob(containerName, blob);
        }
        File outputFile = this.getFileForBlobKey(containerName, blobKey);
        Path outputPath = outputFile.toPath();
        HashingInputStream his = null;
        try {
            com.google.common.io.Files.createParentDirs((File)outputFile);
            his = new HashingInputStream(Hashing.md5(), payload.openStream());
            outputFile.delete();
            com.google.common.io.Files.asByteSink((File)outputFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom((InputStream)his);
            HashCode actualHashCode = his.hash();
            HashCode expectedHashCode = payload.getContentMetadata().getContentMD5AsHashCode();
            if (expectedHashCode != null && !actualHashCode.equals((Object)expectedHashCode)) {
                throw new IOException("MD5 hash code mismatch, actual: " + actualHashCode + " expected: " + expectedHashCode);
            }
            payload.getContentMetadata().setContentMD5(actualHashCode);
            UserDefinedFileAttributeView view = this.getUserDefinedFileAttributeView(outputPath);
            if (view != null) {
                try {
                    view.write(XATTR_CONTENT_MD5, ByteBuffer.wrap(actualHashCode.asBytes()));
                    this.writeCommonMetadataAttr(view, blob);
                }
                catch (IOException e) {
                    this.logger.debug("xattrs not supported on %s", new Object[]{outputPath});
                }
            }
            string = BaseEncoding.base16().lowerCase().encode(actualHashCode.asBytes());
        }
        catch (IOException ex) {
            try {
                if (outputFile != null && !outputFile.delete()) {
                    this.logger.debug("Could not delete %s", new Object[]{outputFile});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                Closeables2.closeQuietly(his);
                if (payload != null) {
                    payload.release();
                }
                throw throwable;
            }
        }
        Closeables2.closeQuietly((Closeable)his);
        if (payload != null) {
            payload.release();
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public void removeBlob(String container, String blobKey) {
        this.filesystemContainerNameValidator.validate(container);
        this.filesystemBlobKeyValidator.validate(blobKey);
        fileName = this.buildPathStartingFromBaseDir(new String[]{container, blobKey});
        this.logger.debug("Deleting blob %s", new Object[]{fileName});
        fileToBeDeleted = new File(fileName);
        if (!fileToBeDeleted.delete()) {
            if (fileToBeDeleted.isDirectory()) {
                try {
                    view = this.getUserDefinedFileAttributeView(fileToBeDeleted.toPath());
                    if (view == null) ** GOTO lbl19
                    for (String s : view.list()) {
                        view.delete(s);
                    }
                }
                catch (IOException e) {
                    this.logger.debug("Could not delete attributes from %s", new Object[]{fileToBeDeleted});
                }
            } else {
                this.logger.debug("Could not delete %s", new Object[]{fileToBeDeleted});
            }
        }
lbl19:
        // 6 sources

        this.removeDirectoriesTreeOfBlobKey(container, blobKey);
    }

    public Location getLocation(String containerName) {
        return null;
    }

    public String getSeparator() {
        return File.separator;
    }

    public boolean createContainer(String container) {
        this.filesystemContainerNameValidator.validate(container);
        return this.createContainerInLocation(container, null);
    }

    public Blob newBlob(@ParamValidators(value={FilesystemBlobKeyValidator.class}) String name) {
        this.filesystemBlobKeyValidator.validate(name);
        return ((BlobBuilder)this.blobBuilders.get()).name(name).build();
    }

    public File getFileForBlobKey(String container, String blobKey) {
        this.filesystemContainerNameValidator.validate(container);
        this.filesystemBlobKeyValidator.validate(blobKey);
        String fileName = this.buildPathStartingFromBaseDir(container, blobKey);
        File blobFile = new File(fileName);
        return blobFile;
    }

    public boolean directoryExists(String container, String directory) {
        return this.buildPathAndChecksIfDirectoryExists(container, directory);
    }

    public void createDirectory(String container, String directory) {
        this.createDirectoryWithResult(container, directory);
    }

    public void deleteDirectory(String container, String directory) {
        String fullDirPath = this.buildPathStartingFromBaseDir(container, directory);
        try {
            Utils.deleteRecursively(new File(fullDirPath));
        }
        catch (IOException ex) {
            this.logger.error("An error occurred removing directory %s.", new Object[]{fullDirPath});
            Throwables.propagate((Throwable)ex);
        }
    }

    public long countBlobs(String container, ListContainerOptions options) {
        try {
            return Iterables.size(this.getBlobKeysInsideContainer(container));
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
    }

    private boolean buildPathAndChecksIfBlobExists(String ... tokens) throws IOException {
        boolean exists;
        String path = this.buildPathStartingFromBaseDir(tokens);
        File file = new File(path);
        boolean bl = exists = file.exists() && file.isFile();
        if (!exists && FilesystemStorageStrategyImpl.getDirectoryBlobSuffix(tokens[tokens.length - 1]) != null && file.isDirectory()) {
            UserDefinedFileAttributeView view = this.getUserDefinedFileAttributeView(file.toPath());
            exists = view != null && view.list().contains(XATTR_CONTENT_MD5);
        }
        return exists;
    }

    private static String getDirectoryBlobSuffix(String key) {
        for (String suffix : BlobStoreConstants.DIRECTORY_SUFFIXES) {
            if (!key.endsWith(suffix)) continue;
            return suffix;
        }
        return null;
    }

    private static String directoryBlobName(String key) {
        String suffix = FilesystemStorageStrategyImpl.getDirectoryBlobSuffix(key);
        if (suffix != null) {
            if (!"/".equals(suffix)) {
                key = key.substring(0, key.lastIndexOf(suffix));
            }
            return key + "/";
        }
        return null;
    }

    private UserDefinedFileAttributeView getUserDefinedFileAttributeView(Path path) throws IOException {
        return Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
    }

    private boolean buildPathAndChecksIfDirectoryExists(String ... tokens) {
        String path = this.buildPathStartingFromBaseDir(tokens);
        File file = new File(path);
        boolean exists = file.exists() || file.isDirectory();
        return exists;
    }

    protected String buildPathStartingFromBaseDir(String ... pathTokens) {
        String normalizedToken = this.removeFileSeparatorFromBorders(FilesystemStorageStrategyImpl.normalize(this.baseDirectory), true);
        StringBuilder completePath = new StringBuilder(normalizedToken);
        if (pathTokens != null && pathTokens.length > 0) {
            for (int i = 0; i < pathTokens.length; ++i) {
                if (pathTokens[i] == null) continue;
                normalizedToken = this.removeFileSeparatorFromBorders(FilesystemStorageStrategyImpl.normalize(pathTokens[i]), false);
                completePath.append(File.separator).append(normalizedToken);
            }
        }
        return completePath.toString();
    }

    private static String normalize(String pathToBeNormalized) {
        if (null != pathToBeNormalized && pathToBeNormalized.contains(BACK_SLASH) && !BACK_SLASH.equals(File.separator)) {
            return pathToBeNormalized.replace(BACK_SLASH, File.separator);
        }
        return pathToBeNormalized;
    }

    private static String denormalize(String pathToDenormalize) {
        if (null != pathToDenormalize && pathToDenormalize.contains("/") && BACK_SLASH.equals(File.separator)) {
            return pathToDenormalize.replace("/", BACK_SLASH);
        }
        return pathToDenormalize;
    }

    private String removeFileSeparatorFromBorders(String pathToBeCleaned, boolean onlyTrailing) {
        if (null == pathToBeCleaned || pathToBeCleaned.equals("")) {
            return pathToBeCleaned;
        }
        int beginIndex = 0;
        int endIndex = pathToBeCleaned.length();
        if (!onlyTrailing && pathToBeCleaned.substring(0, 1).equals(File.separator)) {
            beginIndex = 1;
        }
        if (pathToBeCleaned.substring(pathToBeCleaned.length() - 1).equals(File.separator)) {
            --endIndex;
        }
        return pathToBeCleaned.substring(beginIndex, endIndex);
    }

    private void removeDirectoriesTreeOfBlobKey(String container, String blobKey) {
        File directory;
        String[] children;
        String normalizedBlobKey = FilesystemStorageStrategyImpl.denormalize(blobKey);
        if (!normalizedBlobKey.contains(File.separator)) {
            return;
        }
        File file = new File(normalizedBlobKey);
        String parentPath = file.getParent();
        if (!(Strings.isNullOrEmpty((String)parentPath) || null != (children = (directory = new File(this.buildPathStartingFromBaseDir(container, parentPath))).list()) && children.length != 0)) {
            if (!directory.delete()) {
                this.logger.debug("Could not delete %s", new Object[]{directory});
                return;
            }
            this.removeDirectoriesTreeOfBlobKey(container, parentPath);
        }
    }

    private File openFolder(String folderName) throws IOException {
        String baseFolderName = this.buildPathStartingFromBaseDir(folderName);
        File folder = new File(baseFolderName);
        if (folder.exists() && !folder.isDirectory()) {
            throw new IOException("Resource " + baseFolderName + " isn't a folder.");
        }
        return folder;
    }

    private static void populateBlobKeysInContainer(File directory, Set<String> blobNames, Function<String, String> function) {
        File[] children = directory.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (child.isFile()) {
                blobNames.add((String)function.apply((Object)child.getAbsolutePath()));
                continue;
            }
            if (!child.isDirectory()) continue;
            blobNames.add((String)function.apply((Object)child.getAbsolutePath()) + File.separator);
            FilesystemStorageStrategyImpl.populateBlobKeysInContainer(child, blobNames, function);
        }
    }

    protected boolean createDirectoryWithResult(String container, String directory) {
        String directoryFullName = this.buildPathStartingFromBaseDir(container, directory);
        this.logger.debug("Creating directory %s", new Object[]{directoryFullName});
        if (this.buildPathAndChecksIfDirectoryExists(container, directory)) {
            this.logger.debug("Directory %s already exists", new Object[]{directoryFullName});
            return false;
        }
        File directoryToCreate = new File(directoryFullName);
        boolean result = directoryToCreate.mkdirs();
        return result;
    }

    private static String readStringAttributeIfPresent(UserDefinedFileAttributeView view, Set<String> attributes, String name) throws IOException {
        if (!attributes.contains(name)) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.allocate(view.size(name));
        view.read(name, buf);
        return new String(buf.array(), StandardCharsets.UTF_8);
    }

    private static void writeStringAttributeIfPresent(UserDefinedFileAttributeView view, String name, String value) throws IOException {
        if (value != null) {
            view.write(name, ByteBuffer.wrap(value.getBytes(StandardCharsets.UTF_8)));
        }
    }

    private static void copyStringAttributeIfPresent(UserDefinedFileAttributeView view, String name, Map<String, String> attrs) throws IOException {
        FilesystemStorageStrategyImpl.writeStringAttributeIfPresent(view, name, attrs.get(name));
    }
}

