/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.predicates.validators.internal;

import com.google.inject.Singleton;
import java.io.File;
import org.jclouds.filesystem.predicates.validators.FilesystemBlobKeyValidator;

@Singleton
public class FilesystemBlobKeyValidatorImpl
extends FilesystemBlobKeyValidator {
    public void validate(String name) throws IllegalArgumentException {
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("Blob key can't be null or empty");
        }
        if (name.startsWith(File.separator)) {
            throw new IllegalArgumentException(String.format("Blob key '%s' cannot start with character %s", name, File.separator));
        }
    }
}

