/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.solr;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.nosql.solr.SolrServer;
import brooklyn.entity.nosql.solr.SolrServerDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.event.feed.http.HttpValueFunctions;
import brooklyn.location.access.BrooklynAccessUtils;
import com.google.common.base.Functions;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class SolrServerImpl
extends SoftwareProcessImpl
implements SolrServer {
    private volatile HttpFeed httpFeed;

    @Override
    public Integer getSolrPort() {
        return (Integer)this.getAttribute((AttributeSensor)SolrServer.SOLR_PORT);
    }

    public Class<SolrServerDriver> getDriverInterface() {
        return SolrServerDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)this.getSolrPort());
        String solrUri = String.format("http://%s:%d/solr", hp.getHostText(), hp.getPort());
        this.setAttribute(Attributes.MAIN_URI, URI.create(solrUri));
        this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).period(500L, TimeUnit.MILLISECONDS).baseUri(solrUri).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SERVICE_UP).onSuccess(HttpValueFunctions.responseCodeEquals((int)200))).onFailureOrException(Functions.constant((Object)false))).build();
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
    }
}

