/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.solr;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.java.UsesJava;
import brooklyn.entity.java.UsesJavaMXBeans;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.nosql.solr.SolrServerImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Map;

@Catalog(name="Apache Solr Node", description="Solr is the popular, blazing fast open source enterprise search platform from the Apache Lucene project.", iconUrl="classpath:///solr-logo.jpeg")
@ImplementedBy(value=SolrServerImpl.class)
public interface SolrServer
extends SoftwareProcess,
UsesJava,
UsesJmx,
UsesJavaMXBeans {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"4.7.2");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"${driver.mirrorUrl}/${version}/solr-${version}.tgz");
    @SetFromFlag(value="mirrorUrl")
    public static final ConfigKey<String> MIRROR_URL = ConfigKeys.newStringConfigKey((String)"solr.install.mirror.url", (String)"URL of mirror", (String)"http://mirrors.ukfast.co.uk/sites/ftp.apache.org/lucene/solr/");
    @SetFromFlag(value="solrPort")
    public static final PortAttributeSensorAndConfigKey SOLR_PORT = new PortAttributeSensorAndConfigKey("solr.http.port", "Solr HTTP communications port", (Object)PortRanges.fromString((String)"8983+"));
    @SetFromFlag(value="solrConfigTemplateUrl")
    public static final ConfigKey<String> SOLR_CONFIG_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"solr.config.templateUrl", (String)"Template file (in freemarker format) for the solr.xml config file", (String)"classpath://brooklyn/entity/nosql/solr/solr.xml");
    @SetFromFlag(value="coreConfigMap")
    public static final ConfigKey<Map<String, String>> SOLR_CORE_CONFIG = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"solr.core.config", (String)"Map of core names to core configuration archive URL", (Object)Maps.newHashMap());
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);

    public Integer getSolrPort();
}

