/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.riak;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.nosql.riak.RiakNode;
import brooklyn.entity.nosql.riak.RiakNodeDriver;
import brooklyn.entity.webapp.WebAppServiceMethods;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.event.feed.http.HttpValueFunctions;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.PortRange;
import brooklyn.location.access.BrooklynAccessUtils;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.guava.Functionals;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.net.HostAndPort;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class RiakNodeImpl
extends SoftwareProcessImpl
implements RiakNode {
    private volatile HttpFeed httpFeed;

    public RiakNodeDriver getDriver() {
        return (RiakNodeDriver)super.getDriver();
    }

    public Class<RiakNodeDriver> getDriverInterface() {
        return RiakNodeDriver.class;
    }

    public void init() {
        super.init();
        Entities.getRequiredUrlConfig((Entity)this, (ConfigKey)RIAK_VM_ARGS_TEMPLATE_URL);
        Entities.getRequiredUrlConfig((Entity)this, (ConfigKey)RIAK_APP_CONFIG_TEMPLATE_URL);
    }

    public boolean isPackageDownloadUrlProvided() {
        AttributeSensorAndConfigKey[] downloadProperties;
        for (AttributeSensorAndConfigKey property : downloadProperties = new AttributeSensorAndConfigKey[]{DOWNLOAD_URL_RHEL_CENTOS, DOWNLOAD_URL_UBUNTU, DOWNLOAD_URL_DEBIAN}) {
            if (this.config().getRaw((ConfigKey.HasConfigKey)property).isAbsent()) continue;
            return true;
        }
        return false;
    }

    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation location) {
        ConfigBag result = ConfigBag.newInstance((Map)super.obtainProvisioningFlags(location));
        result.configure(CloudLocationConfig.OS_64_BIT, (Object)true);
        return result.getAllConfig();
    }

    protected Collection<Integer> getRequiredOpenPorts() {
        int erlangRangeStart = (Integer)((PortRange)this.getConfig((ConfigKey.HasConfigKey)ERLANG_PORT_RANGE_START)).iterator().next();
        int erlangRangeEnd = (Integer)((PortRange)this.getConfig((ConfigKey.HasConfigKey)ERLANG_PORT_RANGE_END)).iterator().next();
        MutableSet ports = MutableSet.copyOf((Iterable)super.getRequiredOpenPorts());
        ContiguousSet erlangPorts = ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(erlangRangeStart), (Comparable)Integer.valueOf(erlangRangeEnd)), (DiscreteDomain)DiscreteDomain.integers());
        ports.addAll(erlangPorts);
        return ports;
    }

    public void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        HostAndPort accessible = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)this.getRiakWebPort());
        HttpFeed.Builder httpFeedBuilder = HttpFeed.builder().entity((EntityLocal)this).period(500L, TimeUnit.MILLISECONDS).baseUri(String.format("http://%s/stats", accessible.toString())).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(NODE_GETS).onSuccess(HttpValueFunctions.jsonContents((String)"node_gets", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(NODE_GETS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"node_gets_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(NODE_PUTS).onSuccess(HttpValueFunctions.jsonContents((String)"node_puts", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(NODE_PUTS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"node_puts_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(VNODE_GETS).onSuccess(HttpValueFunctions.jsonContents((String)"vnode_gets", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(VNODE_GETS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"vnode_gets_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(VNODE_PUTS).onSuccess(HttpValueFunctions.jsonContents((String)"vnode_puts", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(VNODE_PUTS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"vnode_puts_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(READ_REPAIRS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"read_repairs_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(COORD_REDIRS_TOTAL).onSuccess(HttpValueFunctions.jsonContents((String)"coord_redirs_total", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(MEMORY_PROCESSES_USED).onSuccess(HttpValueFunctions.jsonContents((String)"memory_processes_used", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SYS_PROCESS_COUNT).onSuccess(HttpValueFunctions.jsonContents((String)"sys_process_count", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(PBC_CONNECTS).onSuccess(HttpValueFunctions.jsonContents((String)"pbc_connects", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(PBC_ACTIVE).onSuccess(HttpValueFunctions.jsonContents((String)"pbc_active", Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(RING_MEMBERS).onSuccess(Functionals.chain((Function)HttpValueFunctions.jsonContents((String)"ring_members", String[].class), (Function)new Function<String[], List<String>>(){

            @Nullable
            public List<String> apply(@Nullable String[] strings) {
                return Arrays.asList(strings);
            }
        }))).onFailureOrException(Functions.constant(Arrays.asList(new String[0]))));
        for (AttributeSensor sensor : ONE_MINUTE_SENSORS) {
            httpFeedBuilder.poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(sensor).period(Duration.ONE_MINUTE)).onSuccess(HttpValueFunctions.jsonContents((String)sensor.getName().substring(5), Integer.class))).onFailureOrException(Functions.constant((Object)-1)));
        }
        this.httpFeed = httpFeedBuilder.build();
        WebAppServiceMethods.connectWebAppServerPolicies((EntityLocal)this);
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        this.disconnectServiceUpIsRunning();
    }

    @Override
    public void joinCluster(String nodeName) {
        this.getDriver().joinCluster(nodeName);
    }

    @Override
    public void leaveCluster() {
        this.getDriver().leaveCluster();
    }

    @Override
    public void removeNode(String nodeName) {
        this.getDriver().removeNode(nodeName);
    }

    @Override
    public void bucketTypeCreate(String bucketTypeName, String bucketTypeProperties) {
        this.getDriver().bucketTypeCreate(bucketTypeName, bucketTypeProperties);
    }

    @Override
    public List<String> bucketTypeList() {
        return this.getDriver().bucketTypeList();
    }

    @Override
    public List<String> bucketTypeStatus(String bucketTypeName) {
        return this.getDriver().bucketTypeStatus(bucketTypeName);
    }

    @Override
    public void bucketTypeUpdate(String bucketTypeName, String bucketTypeProperties) {
        this.getDriver().bucketTypeUpdate(bucketTypeName, bucketTypeProperties);
    }

    @Override
    public void bucketTypeActivate(String bucketTypeName) {
        this.getDriver().bucketTypeActivate(bucketTypeName);
    }

    @Override
    public void recoverFailedNode(String nodeName) {
        this.getDriver().recoverFailedNode(nodeName);
    }

    @Override
    public Integer getRiakWebPort() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.RIAK_WEB_PORT);
    }

    @Override
    public Integer getRiakPbPort() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.RIAK_PB_PORT);
    }

    @Override
    public Integer getHandoffListenerPort() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.HANDOFF_LISTENER_PORT);
    }

    @Override
    public Integer getEpmdListenerPort() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.EPMD_LISTENER_PORT);
    }

    @Override
    public Integer getErlangPortRangeStart() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.ERLANG_PORT_RANGE_START);
    }

    @Override
    public Integer getErlangPortRangeEnd() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.ERLANG_PORT_RANGE_END);
    }

    @Override
    public Integer getSearchSolrPort() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.SEARCH_SOLR_PORT);
    }

    @Override
    public Integer getSearchSolrJmxPort() {
        return (Integer)this.getAttribute((AttributeSensor)RiakNode.SEARCH_SOLR_JMX_PORT);
    }

    @Override
    public String getMajorVersion() {
        return this.getFullVersion().substring(0, 3);
    }

    @Override
    public String getFullVersion() {
        return (String)this.getConfig(RiakNode.SUGGESTED_VERSION);
    }

    @Override
    public String getOsMajorVersion() {
        return this.getDriver().getOsMajorVersion();
    }
}

