/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.riak;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.nosql.riak.RiakClusterImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Map;

@Catalog(name="Riak Cluster", description="Riak is a distributed NoSQL key-value data store that offers extremely high availability, fault tolerance, operational simplicity and scalability.")
@ImplementedBy(value=RiakClusterImpl.class)
public interface RiakCluster
extends DynamicCluster {
    public static final AttributeSensor<Map<Entity, String>> RIAK_CLUSTER_NODES = Sensors.newSensor((TypeToken)new TypeToken<Map<Entity, String>>(){}, (String)"riak.cluster.nodes", (String)"Names of all active Riak nodes in the cluster <Entity,Riak Name>");
    @SetFromFlag(value="delayBeforeAdvertisingCluster")
    public static final ConfigKey<Duration> DELAY_BEFORE_ADVERTISING_CLUSTER = ConfigKeys.newConfigKey(Duration.class, (String)"riak.cluster.delayBeforeAdvertisingCluster", (String)"Delay after cluster is started before checking and advertising its availability", (Object)Duration.seconds((Number)120));
    public static final AttributeSensor<Boolean> IS_CLUSTER_INIT = Sensors.newBooleanSensor((String)"riak.cluster.isClusterInit", (String)"Flag to determine if the cluster was already initialized");
    public static final AttributeSensor<Boolean> IS_FIRST_NODE_SET = Sensors.newBooleanSensor((String)"riak.cluster.isFirstNodeSet", (String)"Flag to determine if the first node has been set");
    public static final AttributeSensor<String> NODE_LIST = Sensors.newStringSensor((String)"riak.cluster.nodeList", (String)"List of nodes (including ports), comma separated");
    public static final AttributeSensor<String> NODE_LIST_PB_PORT = Sensors.newStringSensor((String)"riak.cluster.nodeListPbPort", (String)"List of nodes (including ports for riak db clients), comma separated");
    public static final AttributeSensor<URI> RIAK_CONSOLE_URI = Attributes.MAIN_URI;
}

