/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.redis;

import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.nosql.redis.RedisStore;
import brooklyn.entity.nosql.redis.RedisStoreDriver;
import brooklyn.entity.nosql.redis.RedisStoreImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisStoreSshDriver
extends AbstractSoftwareProcessSshDriver
implements RedisStoreDriver {
    private static final Logger LOG = LoggerFactory.getLogger(RedisStoreSshDriver.class);

    public RedisStoreSshDriver(RedisStoreImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("redis-%s", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        MutableMap installGccPackageFlags = MutableMap.of((Object)"onlyifmissing", (Object)"gcc", (Object)"yum", (Object)"gcc", (Object)"apt", (Object)"gcc", (Object)"port", null);
        MutableMap installMakePackageFlags = MutableMap.of((Object)"onlyifmissing", (Object)"make", (Object)"yum", (Object)"make", (Object)"apt", (Object)"make", (Object)"port", null);
        ImmutableList commands = ImmutableList.builder().addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)BashCommands.INSTALL_TAR).add((Object)BashCommands.INSTALL_CURL).add((Object)BashCommands.installPackage((Map)installGccPackageFlags, (String)"redis-prerequisites-gcc")).add((Object)BashCommands.installPackage((Map)installMakePackageFlags, (String)"redis-prerequisites-make")).add((Object)("tar xzfv " + saveAs)).add((Object)String.format("cd redis-%s", this.getVersion())).add((Object)"pushd deps").add((Object)"make lua hiredis linenoise").add((Object)"popd").add((Object)"make clean && make").build();
        this.newScript((String)"installing").failOnNonZeroResultCode().body.append((Collection)commands).execute();
    }

    public void customize() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"customizing").failOnNonZeroResultCode().body.append(new CharSequence[]{String.format("cd %s", this.getExpandedInstallDir()), "make install PREFIX=" + this.getRunDir()}).execute();
        this.copyTemplate((String)this.getEntity().getConfig(RedisStore.REDIS_CONFIG_TEMPLATE_URL), "redis.conf");
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").failOnNonZeroResultCode().body.append((CharSequence)"./bin/redis-server redis.conf").execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)("./bin/redis-cli -p " + this.getEntity().getAttribute((AttributeSensor)RedisStore.REDIS_PORT) + " ping > /dev/null")).execute() == 0;
    }

    public void stop() {
        int exitCode = this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)("./bin/redis-cli -p " + this.getEntity().getAttribute((AttributeSensor)RedisStore.REDIS_PORT) + " shutdown")).execute();
        if (exitCode != 0) {
            LOG.warn("Unexpected exit code when stopping {}: {}", (Object)this.entity, (Object)exitCode);
        }
    }
}

