/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.redis;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.nosql.redis.RedisStoreImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="Redis Server", description="Redis is an open-source, networked, in-memory, key-value data store with optional durability", iconUrl="classpath:///redis-logo.png")
@ImplementedBy(value=RedisStoreImpl.class)
public interface RedisStore
extends SoftwareProcess {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"2.8.4");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://download.redis.io/releases/redis-${version}.tar.gz");
    @SetFromFlag(value="redisPort")
    public static final PortAttributeSensorAndConfigKey REDIS_PORT = new PortAttributeSensorAndConfigKey("redis.port", "Redis port number", (Object)"6379+");
    @SetFromFlag(value="redisConfigTemplateUrl")
    public static final ConfigKey<String> REDIS_CONFIG_TEMPLATE_URL = ConfigKeys.newConfigKey((String)"redis.config.templateUrl", (String)"Template file (in freemarker format) for the redis.conf config file", (Object)"classpath://brooklyn/entity/nosql/redis/redis.conf");
    public static final AttributeSensor<Integer> UPTIME = Sensors.newIntegerSensor((String)"redis.uptime", (String)"Redis uptime in seconds");
    public static final AttributeSensor<Integer> TOTAL_CONNECTIONS_RECEIVED = Sensors.newIntegerSensor((String)"redis.connections.received.total", (String)"Total number of connections accepted by the server");
    public static final AttributeSensor<Integer> TOTAL_COMMANDS_PROCESSED = Sensors.newIntegerSensor((String)"redis.commands.processed.total", (String)"Total number of commands processed by the server");
    public static final AttributeSensor<Integer> EXPIRED_KEYS = Sensors.newIntegerSensor((String)"redis.keys.expired", (String)"Total number of key expiration events");
    public static final AttributeSensor<Integer> EVICTED_KEYS = Sensors.newIntegerSensor((String)"redis.keys.evicted", (String)"Number of evicted keys due to maxmemory limit");
    public static final AttributeSensor<Integer> KEYSPACE_HITS = Sensors.newIntegerSensor((String)"redis.keyspace.hits", (String)"Number of successful lookup of keys in the main dictionary");
    public static final AttributeSensor<Integer> KEYSPACE_MISSES = Sensors.newIntegerSensor((String)"redis.keyspace.misses", (String)"Number of failed lookup of keys in the main dictionary");

    public String getAddress();

    public Integer getRedisPort();
}

