/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.redis;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.nosql.redis.RedisCluster;
import brooklyn.entity.nosql.redis.RedisSlave;
import brooklyn.entity.nosql.redis.RedisStore;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.location.Location;
import java.util.Collection;

public class RedisClusterImpl
extends AbstractEntity
implements RedisCluster {
    protected RedisStore master;
    protected DynamicCluster slaves;

    @Override
    public RedisStore getMaster() {
        return this.master;
    }

    @Override
    public DynamicCluster getSlaves() {
        return this.slaves;
    }

    public void start(Collection<? extends Location> locations) {
        this.master = (RedisStore)this.addChild(EntitySpec.create(RedisStore.class));
        Entities.manage((Entity)this.master);
        this.master.start(locations);
        this.slaves = (DynamicCluster)this.addChild(EntitySpec.create(DynamicCluster.class).configure(DynamicCluster.MEMBER_SPEC, (Object)EntitySpec.create(RedisSlave.class).configure(RedisSlave.MASTER, (Object)this.master)));
        this.slaves.start(locations);
        this.setAttribute(Startable.SERVICE_UP, this.calculateServiceUp());
    }

    public void stop() {
        if (this.slaves != null) {
            this.slaves.stop();
        }
        if (this.master != null) {
            this.master.stop();
        }
        this.setAttribute(Startable.SERVICE_UP, false);
    }

    public void restart() {
        throw new UnsupportedOperationException();
    }

    protected boolean calculateServiceUp() {
        boolean up = false;
        for (Entity member : this.slaves.getMembers()) {
            if (!Boolean.TRUE.equals(member.getAttribute(SERVICE_UP))) continue;
            up = true;
        }
        return up;
    }
}

