/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.mongodb.sharding;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.nosql.mongodb.sharding.CoLocatedMongoDBRouter;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBConfigServerCluster;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouter;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterCluster;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBShardCluster;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBShardedDeployment;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.event.Sensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.location.Location;
import brooklyn.policy.PolicySpec;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBShardedDeploymentImpl
extends AbstractEntity
implements MongoDBShardedDeployment {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBShardedDeploymentImpl.class);

    public void init() {
        super.init();
        this.setAttribute(CONFIG_SERVER_CLUSTER, this.addChild(EntitySpec.create(MongoDBConfigServerCluster.class).configure(MongoDBConfigServerCluster.MEMBER_SPEC, this.getConfig(MONGODB_CONFIG_SERVER_SPEC)).configure((ConfigKey)DynamicCluster.INITIAL_SIZE, this.getConfig(CONFIG_CLUSTER_SIZE))));
        this.setAttribute(ROUTER_CLUSTER, this.addChild(EntitySpec.create(MongoDBRouterCluster.class).configure(MongoDBRouterCluster.MEMBER_SPEC, this.getConfig(MONGODB_ROUTER_SPEC)).configure((ConfigKey)DynamicCluster.INITIAL_SIZE, this.getConfig(INITIAL_ROUTER_CLUSTER_SIZE)).configure(MongoDBRouter.CONFIG_SERVERS, DependentConfiguration.attributeWhenReady((Entity)((Entity)this.getAttribute(CONFIG_SERVER_CLUSTER)), MongoDBConfigServerCluster.CONFIG_SERVER_ADDRESSES))));
        this.setAttribute(SHARD_CLUSTER, this.addChild(EntitySpec.create(MongoDBShardCluster.class).configure(MongoDBShardCluster.MEMBER_SPEC, this.getConfig(MONGODB_REPLICA_SET_SPEC)).configure((ConfigKey)DynamicCluster.INITIAL_SIZE, this.getConfig(INITIAL_SHARD_CLUSTER_SIZE))));
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{MongoDBConfigServerCluster.CONFIG_SERVER_ADDRESSES}).from((Entity)this.getAttribute(CONFIG_SERVER_CLUSTER))).build());
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((EntityLocal)this, (Sensor)Attributes.SERVICE_STATE_ACTUAL, (Object)"stopped");
    }

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        try {
            MongoDBRouterCluster routers = (MongoDBRouterCluster)this.getAttribute(ROUTER_CLUSTER);
            MongoDBShardCluster shards = (MongoDBShardCluster)this.getAttribute(SHARD_CLUSTER);
            ImmutableList clusters = ImmutableList.of((Object)this.getAttribute(CONFIG_SERVER_CLUSTER), (Object)routers, (Object)shards);
            Entities.invokeEffectorList((EntityLocal)this, (Iterable)clusters, (Effector)Startable.START, (Map)ImmutableMap.of((Object)"locations", locations)).get();
            if (this.getConfigRaw(MongoDBShardedDeployment.CO_LOCATED_ROUTER_GROUP, true).isPresent()) {
                this.addPolicy(((PolicySpec)PolicySpec.create(ColocatedRouterTrackingPolicy.class).displayName("Co-located router tracker")).configure((CharSequence)"group", (Object)((Group)this.getConfig(MongoDBShardedDeployment.CO_LOCATED_ROUTER_GROUP))));
            }
            ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((EntityLocal)this, (Sensor)Attributes.SERVICE_STATE_ACTUAL);
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void stop() {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPING);
        try {
            Entities.invokeEffectorList((EntityLocal)this, (Iterable)ImmutableList.of((Object)this.getAttribute(CONFIG_SERVER_CLUSTER), (Object)this.getAttribute(ROUTER_CLUSTER), (Object)this.getAttribute(SHARD_CLUSTER)), (Effector)Startable.STOP).get();
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPED);
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((EntityLocal)this, (Sensor)Attributes.SERVICE_STATE_ACTUAL, (Object)"stopped");
    }

    public void restart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MongoDBConfigServerCluster getConfigCluster() {
        return (MongoDBConfigServerCluster)this.getAttribute(CONFIG_SERVER_CLUSTER);
    }

    @Override
    public MongoDBRouterCluster getRouterCluster() {
        return (MongoDBRouterCluster)this.getAttribute(ROUTER_CLUSTER);
    }

    @Override
    public MongoDBShardCluster getShardCluster() {
        return (MongoDBShardCluster)this.getAttribute(SHARD_CLUSTER);
    }

    public static class ColocatedRouterTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityAdded(Entity member) {
            MongoDBRouterCluster cluster = (MongoDBRouterCluster)this.entity.getAttribute(MongoDBShardedDeployment.ROUTER_CLUSTER);
            cluster.addMember((Entity)member.getAttribute(CoLocatedMongoDBRouter.ROUTER));
        }

        protected void onEntityRemoved(Entity member) {
            MongoDBRouterCluster cluster = (MongoDBRouterCluster)this.entity.getAttribute(MongoDBShardedDeployment.ROUTER_CLUSTER);
            cluster.removeMember((Entity)member.getAttribute(CoLocatedMongoDBRouter.ROUTER));
        }
    }
}

