/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.mongodb.sharding;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.nosql.mongodb.MongoDBReplicaSet;
import brooklyn.entity.nosql.mongodb.MongoDBServer;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBConfigServer;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBConfigServerCluster;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouter;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterCluster;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBShardCluster;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBShardedDeploymentImpl;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;
import com.google.common.reflect.TypeToken;

@Catalog(name="MongoDB Sharded Deployment", description="MongoDB (from \"humongous\") is a scalable, high-performance, open source NoSQL database", iconUrl="classpath:///mongodb-logo.png")
@ImplementedBy(value=MongoDBShardedDeploymentImpl.class)
public interface MongoDBShardedDeployment
extends Entity,
Startable {
    @SetFromFlag(value="configClusterSize")
    public static final ConfigKey<Integer> CONFIG_CLUSTER_SIZE = ConfigKeys.newIntegerConfigKey((String)"mongodb.config.cluster.size", (String)"Number of config servers", (Integer)3);
    @SetFromFlag(value="initialRouterClusterSize")
    public static final ConfigKey<Integer> INITIAL_ROUTER_CLUSTER_SIZE = ConfigKeys.newIntegerConfigKey((String)"mongodb.router.cluster.initial.size", (String)"Initial number of routers (mongos)", (Integer)0);
    @SetFromFlag(value="initialShardClusterSize")
    public static final ConfigKey<Integer> INITIAL_SHARD_CLUSTER_SIZE = ConfigKeys.newIntegerConfigKey((String)"mongodb.shard.cluster.initial.size", (String)"Initial number of shards (replicasets)", (Integer)2);
    @SetFromFlag(value="shardReplicaSetSize")
    public static final ConfigKey<Integer> SHARD_REPLICASET_SIZE = ConfigKeys.newIntegerConfigKey((String)"mongodb.shard.replicaset.size", (String)"Number of servers (mongod) in each shard (replicaset)", (Integer)3);
    @SetFromFlag(value="routerUpTimeout")
    public static final ConfigKey<Duration> ROUTER_UP_TIMEOUT = ConfigKeys.newConfigKey(Duration.class, (String)"mongodb.router.up.timeout", (String)"Maximum time to wait for the routers to become available before adding the shards", (Object)Duration.FIVE_MINUTES);
    @SetFromFlag(value="coLocatedRouterGroup")
    public static final ConfigKey<Group> CO_LOCATED_ROUTER_GROUP = ConfigKeys.newConfigKey(Group.class, (String)"mongodb.colocated.router.group", (String)"Group to be monitored for the addition of new CoLocatedMongoDBRouter entities");
    public static final ConfigKey<EntitySpec<?>> MONGODB_ROUTER_SPEC = ConfigKeys.newConfigKey((TypeToken)new TypeToken<EntitySpec<?>>(){}, (String)"mongodb.router.spec", (String)"Spec for Router instances", (Object)EntitySpec.create(MongoDBRouter.class));
    public static final ConfigKey<EntitySpec<?>> MONGODB_REPLICA_SET_SPEC = ConfigKeys.newConfigKey((TypeToken)new TypeToken<EntitySpec<?>>(){}, (String)"mongodb.replicaset.spec", (String)"Spec for Replica Set", (Object)EntitySpec.create(MongoDBReplicaSet.class).configure(MongoDBReplicaSet.MEMBER_SPEC, (Object)EntitySpec.create(MongoDBServer.class)));
    public static final ConfigKey<EntitySpec<?>> MONGODB_CONFIG_SERVER_SPEC = ConfigKeys.newConfigKey((TypeToken)new TypeToken<EntitySpec<?>>(){}, (String)"mongodb.configserver.spec", (String)"Spec for Config Server instances", (Object)EntitySpec.create(MongoDBConfigServer.class));
    public static final AttributeSensor<MongoDBConfigServerCluster> CONFIG_SERVER_CLUSTER = Sensors.newSensor(MongoDBConfigServerCluster.class, (String)"mongodbshardeddeployment.configservers", (String)"Config servers");
    public static final AttributeSensor<MongoDBRouterCluster> ROUTER_CLUSTER = Sensors.newSensor(MongoDBRouterCluster.class, (String)"mongodbshardeddeployment.routers", (String)"Routers");
    public static final AttributeSensor<MongoDBShardCluster> SHARD_CLUSTER = Sensors.newSensor(MongoDBShardCluster.class, (String)"mongodbshardeddeployment.shards", (String)"Shards");

    public MongoDBConfigServerCluster getConfigCluster();

    public MongoDBRouterCluster getRouterCluster();

    public MongoDBShardCluster getShardCluster();
}

