/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.mongodb.sharding;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.group.DynamicClusterImpl;
import brooklyn.entity.nosql.mongodb.MongoDBClientSupport;
import brooklyn.entity.nosql.mongodb.MongoDBReplicaSet;
import brooklyn.entity.nosql.mongodb.MongoDBServer;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouter;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterCluster;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBShardCluster;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBShardedDeployment;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.location.Location;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBShardClusterImpl
extends DynamicClusterImpl
implements MongoDBShardCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBShardClusterImpl.class);
    private Set<Entity> addedMembers = Sets.newConcurrentHashSet();
    private Set<Entity> addingMembers = Sets.newConcurrentHashSet();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    protected EntitySpec<?> getMemberSpec() {
        EntitySpec result = super.getMemberSpec();
        if (result == null) {
            result = EntitySpec.create(MongoDBReplicaSet.class);
        }
        result.configure((ConfigKey)DynamicClusterImpl.INITIAL_SIZE, this.getConfig(MongoDBShardedDeployment.SHARD_REPLICASET_SIZE));
        return result;
    }

    public void start(Collection<? extends Location> locations) {
        this.subscribeToMembers((Group)this, (Sensor)Startable.SERVICE_UP, (SensorEventListener)new SensorEventListener<Boolean>(){

            public void onEvent(SensorEvent<Boolean> event) {
                MongoDBShardClusterImpl.this.addShards();
            }
        });
        super.start(locations);
        MongoDBRouterCluster routers = (MongoDBRouterCluster)this.getParent().getAttribute(MongoDBShardedDeployment.ROUTER_CLUSTER);
        this.subscribe((Entity)routers, (Sensor)MongoDBRouterCluster.ANY_RUNNING_ROUTER, (SensorEventListener)new SensorEventListener<MongoDBRouter>(){

            public void onEvent(SensorEvent<MongoDBRouter> event) {
                if (event.getValue() != null) {
                    MongoDBShardClusterImpl.this.addShards();
                }
            }
        });
    }

    public void stop() {
        this.executor.shutdownNow();
        super.stop();
    }

    public void onManagementStopped() {
        super.onManagementStopped();
        this.executor.shutdownNow();
    }

    protected void addShards() {
        MongoDBRouter router = (MongoDBRouter)((MongoDBRouterCluster)this.getParent().getAttribute(MongoDBShardedDeployment.ROUTER_CLUSTER)).getAttribute(MongoDBRouterCluster.ANY_RUNNING_ROUTER);
        if (router == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Not adding shards because no running router in {}", (Object)this);
            }
            return;
        }
        for (Entity member : this.getMembers()) {
            if (!((Boolean)member.getAttribute(Startable.SERVICE_UP)).booleanValue() || this.addingMembers.contains(member)) continue;
            LOG.info("{} adding shard {}", new Object[]{this, member});
            this.addingMembers.add(member);
            this.addShardAsync(member);
        }
    }

    protected void addShardAsync(final Entity replicaSet) {
        final Duration timeout = Duration.minutes((Number)20);
        final Stopwatch stopwatch = Stopwatch.createStarted();
        final AtomicInteger attempts = new AtomicInteger();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                boolean reschedule;
                MongoDBRouter router = (MongoDBRouter)((MongoDBRouterCluster)MongoDBShardClusterImpl.this.getParent().getAttribute(MongoDBShardedDeployment.ROUTER_CLUSTER)).getAttribute(MongoDBRouterCluster.ANY_RUNNING_ROUTER);
                if (router == null) {
                    LOG.debug("Rescheduling adding shard {} because no running router for cluster {}", (Object)replicaSet, (Object)this);
                    reschedule = true;
                } else {
                    MongoDBClientSupport client;
                    try {
                        client = MongoDBClientSupport.forServer(router);
                    }
                    catch (UnknownHostException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                    MongoDBServer primary = (MongoDBServer)replicaSet.getAttribute(MongoDBReplicaSet.PRIMARY_ENTITY);
                    if (primary != null) {
                        String addr = Strings.removeFromStart((String)((String)primary.getAttribute(MongoDBServer.MONGO_SERVER_ENDPOINT)), (String)"http://");
                        String replicaSetURL = ((MongoDBReplicaSet)replicaSet).getName() + "/" + addr;
                        boolean added = client.addShardToRouter(replicaSetURL);
                        if (added) {
                            LOG.info("{} added shard {} via {}", new Object[]{MongoDBShardClusterImpl.this, replicaSetURL, router});
                            MongoDBShardClusterImpl.this.addedMembers.add(replicaSet);
                            reschedule = false;
                        } else {
                            LOG.debug("Rescheduling addition of shard {} because add failed via router {}", (Object)replicaSetURL, (Object)router);
                            reschedule = true;
                        }
                    } else {
                        LOG.debug("Rescheduling addition of shard {} because primary is null", (Object)replicaSet);
                        reschedule = true;
                    }
                }
                if (reschedule) {
                    int numAttempts = attempts.incrementAndGet();
                    if (numAttempts > 1 && timeout.toMilliseconds() > stopwatch.elapsed(TimeUnit.MILLISECONDS)) {
                        MongoDBShardClusterImpl.this.executor.schedule(this, 3L, TimeUnit.SECONDS);
                    } else {
                        LOG.warn("Timeout after {} attempts ({}) adding shard {}; aborting", new Object[]{numAttempts, Time.makeTimeStringRounded((Stopwatch)stopwatch), replicaSet});
                        MongoDBShardClusterImpl.this.addingMembers.remove(replicaSet);
                    }
                }
            }
        });
    }
}

