/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.mongodb.sharding;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.nosql.mongodb.AbstractMongoDBServer;
import brooklyn.entity.nosql.mongodb.AbstractMongoDBSshDriver;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouter;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterDriver;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterImpl;
import brooklyn.location.basic.SshMachineLocation;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBRouterSshDriver
extends AbstractMongoDBSshDriver
implements MongoDBRouterDriver {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBRouterSshDriver.class);

    public MongoDBRouterSshDriver(MongoDBRouterImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public void launch() {
        String configdb = Joiner.on((String)",").join((Iterable)this.getEntity().getConfig(MongoDBRouter.CONFIG_SERVERS));
        ImmutableList.Builder argsBuilder = this.getArgsBuilderWithDefaults((AbstractMongoDBServer)MongoDBRouterImpl.class.cast(this.getEntity())).add((Object[])new String[]{"--configdb", configdb});
        String args = Joiner.on((String)" ").join((Iterable)argsBuilder.build());
        String command = String.format("%s/bin/mongos %s > out.log 2> err.log < /dev/null", this.getExpandedInstallDir(), args);
        LOG.info(command);
        this.newScript((String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)command).execute();
    }
}

