/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.mongodb.sharding;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.nosql.mongodb.MongoDBClientSupport;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouter;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterDriver;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import com.google.common.base.Functions;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class MongoDBRouterImpl
extends SoftwareProcessImpl
implements MongoDBRouter {
    private volatile FunctionFeed functionFeed;

    public Class<?> getDriverInterface() {
        return MongoDBRouterDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.functionFeed = FunctionFeed.builder().entity((EntityLocal)this).poll((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(RUNNING).period(5L, TimeUnit.SECONDS)).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                MongoDBClientSupport clientSupport = MongoDBClientSupport.forServer(MongoDBRouterImpl.this);
                return clientSupport.ping();
            }
        }).onException(Functions.constant((Object)false))).poll((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(SERVICE_UP).period(5L, TimeUnit.SECONDS)).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                MongoDBClientSupport clientSupport = MongoDBClientSupport.forServer(MongoDBRouterImpl.this);
                return clientSupport.ping() && (Integer)MongoDBRouterImpl.this.getAttribute(MongoDBRouter.SHARD_COUNT) > 0;
            }
        }).onException(Functions.constant((Object)false))).poll((FunctionPollConfig)((FunctionPollConfig)new FunctionPollConfig(SHARD_COUNT).period(5L, TimeUnit.SECONDS)).callable((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                MongoDBClientSupport clientSupport = MongoDBClientSupport.forServer(MongoDBRouterImpl.this);
                return (int)clientSupport.getShardCount();
            }
        }).onException(Functions.constant((Object)-1))).build();
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        if (this.functionFeed != null) {
            this.functionFeed.stop();
        }
    }
}

