/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.mongodb.sharding;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import brooklyn.entity.group.DynamicClusterImpl;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouter;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterCluster;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.location.Location;
import brooklyn.policy.PolicySpec;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;

public class MongoDBRouterClusterImpl
extends DynamicClusterImpl
implements MongoDBRouterCluster {
    public void init() {
        super.init();
        this.subscribeToChildren((Entity)this, (Sensor)MongoDBRouter.RUNNING, (SensorEventListener)new SensorEventListener<Boolean>(){

            public void onEvent(SensorEvent<Boolean> event) {
                MongoDBRouterClusterImpl.this.setAnyRouter();
            }
        });
    }

    public void start(Collection<? extends Location> locations) {
        super.start(locations);
        this.addPolicy(((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Router cluster membership tracker")).configure((CharSequence)"group", (Object)this));
    }

    protected void setAnyRouter() {
        this.setAttribute(MongoDBRouterCluster.ANY_ROUTER, Iterables.tryFind(this.getRouters(), (Predicate)EntityPredicates.attributeEqualTo((AttributeSensor)Startable.SERVICE_UP, (Object)true)).orNull());
        this.setAttribute(MongoDBRouterCluster.ANY_RUNNING_ROUTER, Iterables.tryFind(this.getRouters(), (Predicate)EntityPredicates.attributeEqualTo(MongoDBRouter.RUNNING, (Object)true)).orNull());
    }

    @Override
    public Collection<MongoDBRouter> getRouters() {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.getMembers(), MongoDBRouter.class));
    }

    protected EntitySpec<?> getMemberSpec() {
        if (super.getMemberSpec() != null) {
            return super.getMemberSpec();
        }
        return EntitySpec.create(MongoDBRouter.class);
    }

    @Override
    public MongoDBRouter getAnyRouter() {
        return (MongoDBRouter)this.getAttribute(MongoDBRouterCluster.ANY_ROUTER);
    }

    @Override
    public MongoDBRouter getAnyRunningRouter() {
        return (MongoDBRouter)this.getAttribute(MongoDBRouterCluster.ANY_RUNNING_ROUTER);
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity member) {
            ((MongoDBRouterClusterImpl)this.entity).setAnyRouter();
        }

        protected void onEntityRemoved(Entity member) {
            ((MongoDBRouterClusterImpl)this.entity).setAnyRouter();
        }

        protected void onEntityChange(Entity member) {
            ((MongoDBRouterClusterImpl)this.entity).setAnyRouter();
        }
    }
}

