/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.mongodb.sharding;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.nosql.mongodb.AbstractMongoDBServer;
import brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.time.Duration;
import com.google.common.reflect.TypeToken;

@Catalog(name="MongoDB Router", description="MongoDB (from \"humongous\") is a scalable, high-performance, open source NoSQL database", iconUrl="classpath:///mongodb-logo.png")
@ImplementedBy(value=MongoDBRouterImpl.class)
public interface MongoDBRouter
extends AbstractMongoDBServer {
    public static final ConfigKey<Iterable<String>> CONFIG_SERVERS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Iterable<String>>(){}, (String)"mongodb.router.config.servers", (String)"List of host names and ports of the config servers");
    public static final AttributeSensor<Integer> SHARD_COUNT = Sensors.newIntegerSensor((String)"mongodb.router.config.shard.count", (String)"Number of shards that have been added");
    public static final AttributeSensor<Boolean> RUNNING = Sensors.newBooleanSensor((String)"mongodb.router.running", (String)"Indicates that the router is running, and can be used to add shards, but is not necessarity available for CRUD operations (e.g. if no shards have been added)");

    public void waitForServiceUp(Duration var1);
}

