/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.mongodb;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.nosql.mongodb.AbstractMongoDBSshDriver;
import brooklyn.entity.nosql.mongodb.MongoDBDriver;
import brooklyn.entity.nosql.mongodb.MongoDBServer;
import brooklyn.entity.nosql.mongodb.MongoDBServerImpl;
import brooklyn.location.basic.SshMachineLocation;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;

public class MongoDBSshDriver
extends AbstractMongoDBSshDriver
implements MongoDBDriver {
    public MongoDBSshDriver(MongoDBServerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public MongoDBServerImpl getEntity() {
        return (MongoDBServerImpl)MongoDBServerImpl.class.cast(super.getEntity());
    }

    public void launch() {
        MongoDBServerImpl server = this.getEntity();
        ImmutableList.Builder argsBuilder = this.getArgsBuilderWithDefaults(server).add((Object[])new String[]{"--dbpath", this.getDataDirectory()});
        if (server.isReplicaSetMember()) {
            String replicaSetName = server.getReplicaSet().getName();
            Preconditions.checkState((!Strings.isNullOrEmpty((String)replicaSetName) ? 1 : 0) != 0, (Object)"Replica set name must not be null or empty");
            argsBuilder.add((Object[])new String[]{"--replSet", replicaSetName});
        }
        if (Boolean.TRUE.equals(server.getConfig(MongoDBServer.ENABLE_REST_INTERFACE))) {
            argsBuilder.add((Object)"--rest");
        }
        this.launch((ImmutableList.Builder<String>)argsBuilder);
    }
}

