/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.mongodb;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.nosql.mongodb.MongoDBReplicaSetImpl;
import brooklyn.entity.nosql.mongodb.MongoDBServer;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;

@ImplementedBy(value=MongoDBReplicaSetImpl.class)
public interface MongoDBReplicaSet
extends DynamicCluster {
    @SetFromFlag(value="replicaSetName")
    public static final ConfigKey<String> REPLICA_SET_NAME = ConfigKeys.newStringConfigKey((String)"mongodb.replicaSet.name", (String)"Name of the MongoDB replica set", (String)"BrooklynCluster");
    public static final ConfigKey<Integer> INITIAL_SIZE = ConfigKeys.newConfigKeyWithDefault((ConfigKey)Cluster.INITIAL_SIZE, (Object)3);
    public static final AttributeSensor<MongoDBServer> PRIMARY_ENTITY = Sensors.newSensor(MongoDBServer.class, (String)"mongodb.replicaSet.primary.entity", (String)"The entity acting as primary");
    public static final AttributeSensor<List<String>> REPLICA_SET_ENDPOINTS = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"mongodb.replicaSet.endpoints", (String)"Endpoints active for this replica set");

    public String getName();

    public MongoDBServer getPrimary();

    public Collection<MongoDBServer> getSecondaries();

    public Collection<MongoDBServer> getReplicas();
}

