/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.mongodb;

import brooklyn.entity.Entity;
import brooklyn.entity.nosql.mongodb.AbstractMongoDBServer;
import brooklyn.entity.nosql.mongodb.MongoDBServer;
import brooklyn.entity.nosql.mongodb.ReplicaSetConfig;
import brooklyn.event.AttributeSensor;
import brooklyn.location.access.BrooklynAccessUtils;
import com.google.common.base.Optional;
import com.google.common.net.HostAndPort;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBClientSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBClientSupport.class);
    private ServerAddress address;
    private static final MongoClientOptions connectionOptions = MongoClientOptions.builder().autoConnectRetry(true).socketKeepAlive(true).build();
    private static final BasicBSONObject EMPTY_RESPONSE = new BasicBSONObject();

    private MongoClient client() {
        return new MongoClient(this.address, connectionOptions);
    }

    public MongoDBClientSupport(ServerAddress standalone) {
        this.address = standalone;
    }

    public static MongoDBClientSupport forServer(AbstractMongoDBServer standalone) throws UnknownHostException {
        HostAndPort hostAndPort = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)standalone, (int)((Integer)standalone.getAttribute((AttributeSensor)MongoDBServer.PORT)));
        ServerAddress address = new ServerAddress(hostAndPort.getHostText(), hostAndPort.getPort());
        return new MongoDBClientSupport(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerAddress getServerAddress() {
        MongoClient client = this.client();
        try {
            ServerAddress serverAddress = (ServerAddress)client.getServerAddressList().get(0);
            return serverAddress;
        }
        finally {
            client.close();
        }
    }

    private HostAndPort getServerHostAndPort() {
        ServerAddress address = this.getServerAddress();
        return HostAndPort.fromParts((String)address.getHost(), (int)address.getPort());
    }

    public Optional<CommandResult> runDBCommand(String database, String command) {
        return this.runDBCommand(database, (DBObject)new BasicDBObject(command, (Object)Boolean.TRUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CommandResult> runDBCommand(String database, DBObject command) {
        MongoClient client = this.client();
        try {
            CommandResult status;
            DB db = client.getDB(database);
            try {
                status = db.command(command);
            }
            catch (MongoException e) {
                LOG.warn("Command " + command + " on " + this.getServerAddress() + " failed", (Throwable)e);
                Optional optional = Optional.absent();
                client.close();
                return optional;
            }
            if (!status.ok()) {
                LOG.debug("Unexpected result of {} on {}: {}", new Object[]{command, this.getServerAddress(), status.getErrorMessage()});
            }
            Optional optional = Optional.of((Object)status);
            return optional;
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getShardCount() {
        MongoClient client = this.client();
        try {
            long l = client.getDB("config").getCollection("shards").getCount();
            return l;
        }
        finally {
            client.close();
        }
    }

    public BasicBSONObject getServerStatus() {
        Optional<CommandResult> result = this.runDBCommand("admin", "serverStatus");
        if (result.isPresent() && ((CommandResult)result.get()).ok()) {
            return (BasicBSONObject)result.get();
        }
        return EMPTY_RESPONSE;
    }

    public boolean ping() {
        BasicDBObject ping = new BasicDBObject("ping", (Object)"1");
        try {
            this.runDBCommand("admin", (DBObject)ping);
        }
        catch (MongoException e) {
            return false;
        }
        return true;
    }

    public boolean initializeReplicaSet(String replicaSetName, Integer id) {
        HostAndPort primary = this.getServerHostAndPort();
        BasicBSONObject config = ReplicaSetConfig.builder(replicaSetName).member(primary, id).build();
        BasicDBObject dbObject = new BasicDBObject("replSetInitiate", (Object)config);
        LOG.debug("Initiating replica set with: " + dbObject);
        Optional<CommandResult> result = this.runDBCommand("admin", (DBObject)dbObject);
        if (result.isPresent() && ((CommandResult)result.get()).ok() && LOG.isDebugEnabled()) {
            LOG.debug("Completed initiating MongoDB replica set {} on entity {}", (Object)replicaSetName, (Object)this);
        }
        return result.isPresent() && ((CommandResult)result.get()).ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BSONObject getReplicaSetConfig() {
        MongoClient client = this.client();
        try {
            DBObject dBObject = client.getDB("local").getCollection("system.replset").findOne();
            return dBObject;
        }
        catch (MongoException e) {
            LOG.error("Failed to get replica set config on " + client, (Throwable)e);
            BSONObject bSONObject = null;
            return bSONObject;
        }
        finally {
            client.close();
        }
    }

    public BasicBSONObject getReplicaSetStatus() {
        Optional<CommandResult> result = this.runDBCommand("admin", "replSetGetStatus");
        if (result.isPresent() && ((CommandResult)result.get()).ok()) {
            return (BasicBSONObject)result.get();
        }
        return EMPTY_RESPONSE;
    }

    public boolean addMemberToReplicaSet(MongoDBServer secondary, Integer id) {
        BSONObject existingConfig = this.getReplicaSetConfig();
        if (existingConfig == null) {
            LOG.warn("Couldn't load existing config for replica set from {}. Server {} not added.", (Object)this.getServerAddress(), (Object)secondary);
            return false;
        }
        BasicBSONObject newConfig = ReplicaSetConfig.fromExistingConfig(existingConfig).primary(this.getServerHostAndPort()).member(secondary, id).build();
        return this.reconfigureReplicaSet(newConfig);
    }

    public boolean removeMemberFromReplicaSet(MongoDBServer server) {
        BSONObject existingConfig = this.getReplicaSetConfig();
        if (existingConfig == null) {
            LOG.warn("Couldn't load existing config for replica set from {}. Server {} not removed.", (Object)this.getServerAddress(), (Object)server);
            return false;
        }
        BasicBSONObject newConfig = ReplicaSetConfig.fromExistingConfig(existingConfig).primary(this.getServerHostAndPort()).remove(server).build();
        return this.reconfigureReplicaSet(newConfig);
    }

    private boolean reconfigureReplicaSet(BasicBSONObject newConfig) {
        BasicDBObject command = new BasicDBObject("replSetReconfig", (Object)newConfig);
        LOG.debug("Reconfiguring replica set to: " + command);
        Optional<CommandResult> result = this.runDBCommand("admin", (DBObject)command);
        return result.isPresent() && ((CommandResult)result.get()).ok();
    }

    public boolean addShardToRouter(String hostAndPort) {
        LOG.debug("Adding shard " + hostAndPort);
        BasicDBObject command = new BasicDBObject("addShard", (Object)hostAndPort);
        Optional<CommandResult> result = this.runDBCommand("admin", (DBObject)command);
        return result.isPresent() && ((CommandResult)result.get()).ok();
    }
}

