/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.elasticsearch;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.nosql.elasticsearch.ElasticSearchNode;
import brooklyn.entity.nosql.elasticsearch.ElasticSearchNodeDriver;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import com.google.common.collect.ImmutableList;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ElasticSearchNodeSshDriver
extends AbstractSoftwareProcessSshDriver
implements ElasticSearchNodeDriver {
    public ElasticSearchNodeSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("elasticsearch-%s", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().add((Object)BashCommands.installJavaLatestOrWarn()).addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)String.format("tar zxvf %s", saveAs)).build();
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        this.newScript("customizing").execute();
        String configFileUrl = (String)this.entity.getConfig(ElasticSearchNode.TEMPLATE_CONFIGURATION_URL);
        if (configFileUrl == null) {
            return;
        }
        String configScriptContents = this.processTemplate(configFileUrl);
        StringReader configContents = new StringReader(configScriptContents);
        this.getMachine().copyTo((Reader)configContents, Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getConfigFile()}));
    }

    public void launch() {
        String pidFile = this.getRunDir() + "/" + "pid.txt";
        this.entity.setAttribute(ElasticSearchNode.PID_FILE, (Object)pidFile);
        StringBuilder commandBuilder = new StringBuilder().append(String.format("%s/bin/elasticsearch -d -p %s", this.getExpandedInstallDir(), pidFile));
        if (this.entity.getConfig(ElasticSearchNode.TEMPLATE_CONFIGURATION_URL) != null) {
            commandBuilder.append(" -Des.config=" + Os.mergePaths((String[])new String[]{this.getRunDir(), this.getConfigFile()}));
        }
        this.appendConfigIfPresent(commandBuilder, "es.path.data", ElasticSearchNode.DATA_DIR, Os.mergePaths((String[])new String[]{this.getRunDir(), "data"}));
        this.appendConfigIfPresent(commandBuilder, "es.path.logs", ElasticSearchNode.LOG_DIR, Os.mergePaths((String[])new String[]{this.getRunDir(), "logs"}));
        this.appendConfigIfPresent(commandBuilder, "es.node.name", ElasticSearchNode.NODE_NAME.getConfigKey());
        this.appendConfigIfPresent(commandBuilder, "es.cluster.name", ElasticSearchNode.CLUSTER_NAME.getConfigKey());
        this.appendConfigIfPresent(commandBuilder, "es.discovery.zen.ping.multicast.enabled", ElasticSearchNode.MULTICAST_ENABLED);
        this.appendConfigIfPresent(commandBuilder, "es.discovery.zen.ping.unicast.enabled", ElasticSearchNode.UNICAST_ENABLED);
        commandBuilder.append(" > out.log 2> err.log < /dev/null");
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)commandBuilder.toString()).execute();
    }

    private void appendConfigIfPresent(StringBuilder builder, String parameter, ConfigKey<?> configKey) {
        this.appendConfigIfPresent(builder, parameter, configKey, null);
    }

    private void appendConfigIfPresent(StringBuilder builder, String parameter, ConfigKey<?> configKey, String defaultValue) {
        String config = null;
        if (this.entity.getConfig(configKey) != null) {
            config = String.valueOf(this.entity.getConfig(configKey));
        }
        if (config == null && defaultValue != null) {
            config = defaultValue;
        }
        if (config != null) {
            builder.append(String.format(" -D%s=%s", parameter, config));
        }
    }

    public String getConfigFile() {
        return "elasticsearch.yaml";
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
    }

    public void kill() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "killing").execute();
    }
}

