/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.elasticsearch;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.nosql.elasticsearch.ElasticSearchNode;
import brooklyn.entity.nosql.elasticsearch.ElasticSearchNodeDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.event.feed.http.HttpValueFunctions;
import brooklyn.event.feed.http.JsonFunctions;
import brooklyn.location.access.BrooklynAccessUtils;
import brooklyn.util.guava.Functionals;
import brooklyn.util.guava.Maybe;
import brooklyn.util.guava.MaybeFunctions;
import brooklyn.util.guava.TypeTokens;
import brooklyn.util.http.HttpToolResponse;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import java.util.Map;

public class ElasticSearchNodeImpl
extends SoftwareProcessImpl
implements ElasticSearchNode {
    protected static final Function<Maybe<JsonElement>, Maybe<JsonElement>> GET_FIRST_NODE_FROM_NODES = new Function<Maybe<JsonElement>, Maybe<JsonElement>>(){

        public Maybe<JsonElement> apply(Maybe<JsonElement> input) {
            if (input.isAbsent()) {
                return input;
            }
            return Maybe.fromNullable(((Map.Entry)((JsonElement)input.get()).getAsJsonObject().entrySet().iterator().next()).getValue());
        }
    };
    protected static final Function<HttpToolResponse, Maybe<JsonElement>> GET_FIRST_NODE = Functionals.chain((Function)HttpValueFunctions.jsonContents(), (Function)MaybeFunctions.wrap(), (Function)JsonFunctions.walkM((String)"nodes"), GET_FIRST_NODE_FROM_NODES);
    HttpFeed httpFeed;

    public Class<ElasticSearchNodeDriver> getDriverInterface() {
        return ElasticSearchNodeDriver.class;
    }

    protected static final <T> HttpPollConfig<T> getSensorFromNodeStat(AttributeSensor<T> sensor, String ... jsonPath) {
        return (HttpPollConfig)((HttpPollConfig)new HttpPollConfig(sensor).onSuccess(Functionals.chain(GET_FIRST_NODE, (Function)JsonFunctions.walkM((String[])jsonPath), (Function)JsonFunctions.castM((Class)TypeTokens.getRawRawType((TypeToken)sensor.getTypeToken()), null)))).onFailureOrException(Functions.constant(null));
    }

    protected void connectSensors() {
        super.connectSensors();
        Integer rawPort = (Integer)this.getAttribute((AttributeSensor)HTTP_PORT);
        Preconditions.checkNotNull((Object)rawPort, (String)"HTTP_PORT sensors not set for %s; is an acceptable port available?", (Object[])new Object[]{this});
        HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)rawPort);
        Function<Maybe<JsonElement>, String> getNodeId = new Function<Maybe<JsonElement>, String>(){

            public String apply(Maybe<JsonElement> input) {
                if (input.isAbsent()) {
                    return null;
                }
                return (String)((Map.Entry)((JsonElement)input.get()).getAsJsonObject().entrySet().iterator().next()).getKey();
            }
        };
        this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).period(1000L).baseUri(String.format("http://%s:%s/_nodes/_local/stats", hp.getHostText(), hp.getPort())).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SERVICE_UP).onSuccess(HttpValueFunctions.responseCodeEquals((int)200))).onFailureOrException(Functions.constant((Object)false))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(NODE_ID).onSuccess(Functionals.chain((Function)HttpValueFunctions.jsonContents(), (Function)MaybeFunctions.wrap(), (Function)JsonFunctions.walkM((String)"nodes"), (Function)getNodeId))).onFailureOrException(Functions.constant((Object)""))).poll(ElasticSearchNodeImpl.getSensorFromNodeStat(NODE_NAME, new String[]{"name"})).poll(ElasticSearchNodeImpl.getSensorFromNodeStat(DOCUMENT_COUNT, "indices", "docs", "count")).poll(ElasticSearchNodeImpl.getSensorFromNodeStat(STORE_BYTES, "indices", "store", "size_in_bytes")).poll(ElasticSearchNodeImpl.getSensorFromNodeStat(GET_TOTAL, "indices", "get", "total")).poll(ElasticSearchNodeImpl.getSensorFromNodeStat(GET_TIME_IN_MILLIS, "indices", "get", "time_in_millis")).poll(ElasticSearchNodeImpl.getSensorFromNodeStat(SEARCH_QUERY_TOTAL, "indices", "search", "query_total")).poll(ElasticSearchNodeImpl.getSensorFromNodeStat(SEARCH_QUERY_TIME_IN_MILLIS, "indices", "search", "query_time_in_millis")).poll((HttpPollConfig)new HttpPollConfig((AttributeSensor)CLUSTER_NAME).onSuccess(HttpValueFunctions.jsonContents((String)"cluster_name", String.class))).build();
    }

    protected void disconnectSensors() {
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
    }
}

