/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.elasticsearch;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.nosql.elasticsearch.ElasticSearchNodeImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.webapp.WebAppServiceConstants;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="Elastic Search Node", description="Elasticsearch is an open-source search server based on Lucene. It provides a distributed, multitenant-capable full-text search engine with a RESTful web interface and schema-free JSON documents.")
@ImplementedBy(value=ElasticSearchNodeImpl.class)
public interface ElasticSearchNode
extends SoftwareProcess,
DatastoreMixins.HasDatastoreUrl {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"1.2.1");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"https://download.elasticsearch.org/elasticsearch/elasticsearch/elasticsearch-${version}.tar.gz");
    @SetFromFlag(value="dataDir")
    public static final ConfigKey<String> DATA_DIR = ConfigKeys.newStringConfigKey((String)"elasticsearch.node.data.dir", (String)"Directory for writing data files", null);
    @SetFromFlag(value="logDir")
    public static final ConfigKey<String> LOG_DIR = ConfigKeys.newStringConfigKey((String)"elasticsearch.node.log.dir", (String)"Directory for writing log files", null);
    @SetFromFlag(value="configFileUrl")
    public static final ConfigKey<String> TEMPLATE_CONFIGURATION_URL = ConfigKeys.newStringConfigKey((String)"elasticsearch.node.template.configuration.url", (String)"URL where the elasticsearch configuration file (in freemarker format) can be found", null);
    @SetFromFlag(value="multicastEnabled")
    public static final ConfigKey<Boolean> MULTICAST_ENABLED = ConfigKeys.newBooleanConfigKey((String)"elasticsearch.node.multicast.enabled", (String)"Indicates whether zen discovery multicast should be enabled for a node", null);
    @SetFromFlag(value="multicastEnabled")
    public static final ConfigKey<Boolean> UNICAST_ENABLED = ConfigKeys.newBooleanConfigKey((String)"elasticsearch.node.UNicast.enabled", (String)"Indicates whether zen discovery unicast should be enabled for a node", null);
    @SetFromFlag(value="httpPort")
    public static final PortAttributeSensorAndConfigKey HTTP_PORT = new PortAttributeSensorAndConfigKey(WebAppServiceConstants.HTTP_PORT, (Object)PortRanges.fromString((String)"9200+"));
    @SetFromFlag(value="nodeName")
    public static final BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey NODE_NAME = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("elasticsearch.node.name", "Node name (or randomly selected if not set", null);
    @SetFromFlag(value="clusterName")
    public static final BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey CLUSTER_NAME = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("elasticsearch.node.cluster.name", "Cluster name (or elasticsearch selected if not set", null);
    public static final AttributeSensor<String> NODE_ID = Sensors.newStringSensor((String)"elasticsearch.node.id");
    public static final AttributeSensor<Integer> DOCUMENT_COUNT = Sensors.newIntegerSensor((String)"elasticsearch.node.docs.count");
    public static final AttributeSensor<Integer> STORE_BYTES = Sensors.newIntegerSensor((String)"elasticsearch.node.store.bytes");
    public static final AttributeSensor<Integer> GET_TOTAL = Sensors.newIntegerSensor((String)"elasticsearch.node.get.total");
    public static final AttributeSensor<Integer> GET_TIME_IN_MILLIS = Sensors.newIntegerSensor((String)"elasticsearch.node.get.time.in.millis");
    public static final AttributeSensor<Integer> SEARCH_QUERY_TOTAL = Sensors.newIntegerSensor((String)"elasticsearch.node.search.query.total");
    public static final AttributeSensor<Integer> SEARCH_QUERY_TIME_IN_MILLIS = Sensors.newIntegerSensor((String)"elasticsearch.node.search.query.time.in.millis");
}

