/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.couchdb;

import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.nosql.couchdb.CouchDBNode;
import brooklyn.entity.nosql.couchdb.CouchDBNodeDriver;
import brooklyn.entity.nosql.couchdb.CouchDBNodeImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDBNodeSshDriver
extends AbstractSoftwareProcessSshDriver
implements CouchDBNodeDriver {
    private static final Logger log = LoggerFactory.getLogger(CouchDBNodeSshDriver.class);

    public CouchDBNodeSshDriver(CouchDBNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
        entity.setAttribute(Attributes.LOG_FILE_LOCATION, this.getLogFileLocation());
    }

    public String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "couchdb.log"});
    }

    @Override
    public Integer getHttpPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)CouchDBNode.HTTP_PORT);
    }

    @Override
    public Integer getHttpsPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)CouchDBNode.HTTPS_PORT);
    }

    @Override
    public String getClusterName() {
        return (String)this.entity.getAttribute(CouchDBNode.CLUSTER_NAME);
    }

    @Override
    public String getCouchDBConfigTemplateUrl() {
        return (String)this.entity.getAttribute(CouchDBNode.COUCHDB_CONFIG_TEMPLATE_URL);
    }

    @Override
    public String getCouchDBUriTemplateUrl() {
        return (String)this.entity.getAttribute(CouchDBNode.COUCHDB_URI_TEMPLATE_URL);
    }

    @Override
    public String getCouchDBConfigFileName() {
        return (String)this.entity.getAttribute(CouchDBNode.COUCHDB_CONFIG_FILE_NAME);
    }

    public String getErlangVersion() {
        return (String)this.entity.getConfig(CouchDBNode.ERLANG_VERSION);
    }

    public void install() {
        log.info("Installing {}", (Object)this.entity);
        ImmutableList commands = ImmutableList.builder().add((Object)BashCommands.ifExecutableElse0((String)"zypper", (String)BashCommands.chainGroup((String[])new String[]{BashCommands.ok((String)BashCommands.sudo((String)"zypper --non-interactive addrepo http://download.opensuse.org/repositories/devel:/languages:/erlang/openSUSE_11.4 erlang_suse_11")), BashCommands.ok((String)BashCommands.sudo((String)"zypper --non-interactive addrepo http://download.opensuse.org/repositories/devel:/languages:/erlang/openSUSE_12.3 erlang_suse_12")), BashCommands.ok((String)BashCommands.sudo((String)"zypper --non-interactive addrepo http://download.opensuse.org/repositories/devel:/languages:/erlang/openSUSE_13.1 erlang_suse_13")), BashCommands.ok((String)BashCommands.sudo((String)"zypper --non-interactive addrepo http://download.opensuse.org/repositories/server:/database/openSUSE_11.4 db_suse_11")), BashCommands.ok((String)BashCommands.sudo((String)"zypper --non-interactive addrepo http://download.opensuse.org/repositories/server:/database/openSUSE_12.3 db_suse_12")), BashCommands.ok((String)BashCommands.sudo((String)"zypper --non-interactive addrepo http://download.opensuse.org/repositories/server:/database/openSUSE_13.1 db_suse_13"))}))).add((Object)BashCommands.installPackage((Map)ImmutableMap.of((Object)"apt", (Object)"erlang-nox erlang-dev", (Object)"port", (Object)("erlang@" + this.getErlangVersion() + "+ssl")), (String)"erlang")).add((Object)BashCommands.installPackage((String)"couchdb")).add((Object)BashCommands.ifExecutableElse0((String)"service", (String)BashCommands.sudo((String)"service couchdb stop"))).build();
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public Set<Integer> getPortsUsed() {
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)super.getPortsUsed());
        result.addAll(this.getPortMap().values());
        return result;
    }

    private Map<String, Integer> getPortMap() {
        return ImmutableMap.builder().put((Object)"httpPort", (Object)this.getHttpPort()).build();
    }

    public void customize() {
        log.info("Customizing {} (Cluster {})", (Object)this.entity, (Object)this.getClusterName());
        Networking.checkPortsValid(this.getPortMap());
        this.newScript("customizing").execute();
        String destinationConfigFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), this.getCouchDBConfigFileName()});
        this.copyTemplate(this.getCouchDBConfigTemplateUrl(), destinationConfigFile);
        String destinationUriFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "couch.uri"});
        this.copyTemplate(this.getCouchDBUriTemplateUrl(), destinationUriFile);
    }

    public void launch() {
        log.info("Launching  {}", (Object)this.entity);
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append((CharSequence)BashCommands.sudo((String)String.format("nohup couchdb -p %s -a %s -o couchdb-console.log -e couchdb-error.log -b &", this.getPidFile(), Os.mergePathsUnix((String[])new String[]{this.getRunDir(), this.getCouchDBConfigFileName()})))).execute();
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "couchdb.pid"});
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)BashCommands.sudo((String)String.format("couchdb -p %s -s", this.getPidFile()))).execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)BashCommands.sudo((String)String.format("couchdb -p %s -k", this.getPidFile()))).failOnNonZeroResultCode().execute();
    }
}

