/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.couchdb;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.nosql.couchdb.CouchDBNode;
import brooklyn.entity.nosql.couchdb.CouchDBNodeDriver;
import brooklyn.entity.webapp.WebAppServiceMethods;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.event.feed.http.HttpValueFunctions;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDBNodeImpl
extends SoftwareProcessImpl
implements CouchDBNode {
    private static final Logger log = LoggerFactory.getLogger(CouchDBNodeImpl.class);
    private volatile HttpFeed httpFeed;

    @Override
    public Integer getHttpPort() {
        return (Integer)this.getAttribute((AttributeSensor)CouchDBNode.HTTP_PORT);
    }

    @Override
    public Integer getHttpsPort() {
        return (Integer)this.getAttribute((AttributeSensor)CouchDBNode.HTTPS_PORT);
    }

    public String getClusterName() {
        return (String)this.getAttribute((AttributeSensor)CouchDBNode.CLUSTER_NAME);
    }

    public Class<CouchDBNodeDriver> getDriverInterface() {
        return CouchDBNodeDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).period(500L, TimeUnit.MILLISECONDS).baseUri(String.format("http://%s:%d/_stats", this.getAttribute(HOSTNAME), this.getHttpPort())).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(REQUEST_COUNT).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"httpd", "requests", "count"}, Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig((AttributeSensor)ERROR_COUNT).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"httpd_status_codes", "404", "count"}, Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(TOTAL_PROCESSING_TIME).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"couchdb", "request_time", "count"}, Integer.class))).onFailureOrException(Functions.constant((Object)-1))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(MAX_PROCESSING_TIME).onSuccess(HttpValueFunctions.chain((Function)HttpValueFunctions.jsonContents((String[])new String[]{"couchdb", "request_time", "max"}, Double.class), (Function)new Function<Double, Integer>(){

            public Integer apply(@Nullable Double input) {
                return input.intValue();
            }
        }))).onFailureOrException(Functions.constant((Object)-1))).build();
        WebAppServiceMethods.connectWebAppServerPolicies((EntityLocal)this);
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        this.disconnectServiceUpIsRunning();
    }

    protected void postStop() {
        super.postStop();
        this.setAttribute(REQUESTS_PER_SECOND_LAST, 0.0);
        this.setAttribute(REQUESTS_PER_SECOND_IN_WINDOW, 0.0);
    }
}

