/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.couchbase;

import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.nosql.couchbase.CouchbaseSyncGateway;
import brooklyn.entity.nosql.couchbase.CouchbaseSyncGatewayDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.event.feed.http.HttpValueFunctions;
import brooklyn.location.access.BrooklynAccessUtils;
import com.google.common.base.Functions;
import com.google.common.net.HostAndPort;

public class CouchbaseSyncGatewayImpl
extends SoftwareProcessImpl
implements CouchbaseSyncGateway {
    private HttpFeed httpFeed;

    public Class<CouchbaseSyncGatewayDriver> getDriverInterface() {
        return CouchbaseSyncGatewayDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
    }

    protected void connectServiceUpIsRunning() {
        HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.getAttribute((AttributeSensor)CouchbaseSyncGateway.ADMIN_REST_API_PORT)));
        String managementUri = String.format("http://%s:%s", hp.getHostText(), hp.getPort());
        this.setAttribute(MANAGEMENT_URL, managementUri);
        this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).period(200L).baseUri(managementUri).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(SERVICE_UP).onSuccess(HttpValueFunctions.responseCodeEquals((int)200))).onFailureOrException(Functions.constant((Object)false))).build();
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
    }

    protected void disconnectServiceUpIsRunning() {
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
    }

    static {
        RendererHints.register((AttributeSensor)MANAGEMENT_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
    }
}

