/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.couchbase;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.nosql.couchbase.CouchbaseNodeImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.text.ByteSizeStrings;
import com.google.common.base.Function;
import java.net.URI;

@Catalog(name="CouchBase Node", description="Couchbase Server is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications.")
@ImplementedBy(value=CouchbaseNodeImpl.class)
public interface CouchbaseNode
extends SoftwareProcess {
    @SetFromFlag(value="adminUsername")
    public static final ConfigKey<String> COUCHBASE_ADMIN_USERNAME = ConfigKeys.newStringConfigKey((String)"couchbase.adminUsername", (String)"Username for the admin user on the node", (String)"Administrator");
    @SetFromFlag(value="adminPassword")
    public static final ConfigKey<String> COUCHBASE_ADMIN_PASSWORD = ConfigKeys.newStringConfigKey((String)"couchbase.adminPassword", (String)"Password for the admin user on the node", (String)"Password");
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"3.0.0");
    @SetFromFlag(value="enterprise")
    public static final ConfigKey<Boolean> USE_ENTERPRISE = ConfigKeys.newBooleanConfigKey((String)"couchbase.enterprise.enabled", (String)"Whether to use Couchbase Enterprise; if false uses the community version. Defaults to true.", (Boolean)true);
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://packages.couchbase.com/releases/${version}/couchbase-server-${driver.communityOrEnterprise}${driver.downloadLinkPreVersionSeparator}${version}${driver.downloadLinkOsTagWithPrefix}");
    @SetFromFlag(value="clusterInitRamSize")
    public static final BasicAttributeSensorAndConfigKey<Integer> COUCHBASE_CLUSTER_INIT_RAM_SIZE = new BasicAttributeSensorAndConfigKey(Integer.class, "couchbase.clusterInitRamSize", "initial ram size of the cluster", (Object)300);
    public static final PortAttributeSensorAndConfigKey COUCHBASE_WEB_ADMIN_PORT = new PortAttributeSensorAndConfigKey("couchbase.webAdminPort", "Web Administration Port", (Object)"8091+");
    public static final PortAttributeSensorAndConfigKey COUCHBASE_API_PORT = new PortAttributeSensorAndConfigKey("couchbase.apiPort", "Couchbase API Port", (Object)"8092+");
    public static final PortAttributeSensorAndConfigKey COUCHBASE_INTERNAL_BUCKET_PORT = new PortAttributeSensorAndConfigKey("couchbase.internalBucketPort", "Internal Bucket Port", (Object)"11209");
    public static final PortAttributeSensorAndConfigKey COUCHBASE_INTERNAL_EXTERNAL_BUCKET_PORT = new PortAttributeSensorAndConfigKey("couchbase.internalExternalBucketPort", "Internal/External Bucket Port", (Object)"11210");
    public static final PortAttributeSensorAndConfigKey COUCHBASE_CLIENT_INTERFACE_PROXY = new PortAttributeSensorAndConfigKey("couchbase.clientInterfaceProxy", "Client interface (proxy)", (Object)"11211");
    public static final PortAttributeSensorAndConfigKey COUCHBASE_INCOMING_SSL_PROXY = new PortAttributeSensorAndConfigKey("couchbase.incomingSslProxy", "Incoming SSL Proxy", (Object)"11214");
    public static final PortAttributeSensorAndConfigKey COUCHBASE_INTERNAL_OUTGOING_SSL_PROXY = new PortAttributeSensorAndConfigKey("couchbase.internalOutgoingSslProxy", "Internal Outgoing SSL Proxy", (Object)"11215");
    public static final PortAttributeSensorAndConfigKey COUCHBASE_REST_HTTPS_FOR_SSL = new PortAttributeSensorAndConfigKey("couchbase.internalRestHttpsForSsl", "Internal REST HTTPS for SSL", (Object)"18091");
    public static final PortAttributeSensorAndConfigKey COUCHBASE_CAPI_HTTPS_FOR_SSL = new PortAttributeSensorAndConfigKey("couchbase.internalCapiHttpsForSsl", "Internal CAPI HTTPS for SSL", (Object)"18092");
    public static final PortAttributeSensorAndConfigKey ERLANG_PORT_MAPPER = new PortAttributeSensorAndConfigKey("couchbase.erlangPortMapper", "Erlang Port Mapper Daemon Listener Port (epmd)", (Object)"4369");
    public static final PortAttributeSensorAndConfigKey NODE_DATA_EXCHANGE_PORT_RANGE_START = new PortAttributeSensorAndConfigKey("couchbase.nodeDataExchangePortRangeStart", "Node data exchange Port Range Start", (Object)"21100+");
    public static final PortAttributeSensorAndConfigKey NODE_DATA_EXCHANGE_PORT_RANGE_END = new PortAttributeSensorAndConfigKey("couchbase.nodeDataExchangePortRangeEnd", "Node data exchange Port Range End", (Object)"21199+");
    public static final AttributeSensor<Boolean> IS_PRIMARY_NODE = Sensors.newBooleanSensor((String)"couchbase.isPrimaryNode", (String)"flag to determine if the current couchbase node is the primary node for the cluster");
    public static final AttributeSensor<Boolean> IS_IN_CLUSTER = Sensors.newBooleanSensor((String)"couchbase.isInCluster", (String)"flag to determine if the current couchbase node has been added to a cluster, including being the first / primary node");
    public static final AttributeSensor<URI> COUCHBASE_WEB_ADMIN_URL = Attributes.MAIN_URI;
    public static final AttributeSensor<Double> OPS = Sensors.newDoubleSensor((String)"couchbase.stats.ops", (String)"Retrieved from pools/nodes/<current node>/interestingStats/ops");
    public static final AttributeSensor<Long> COUCH_DOCS_DATA_SIZE = Sensors.newLongSensor((String)"couchbase.stats.couch.docs.data.size", (String)"Retrieved from pools/nodes/<current node>/interestingStats/couch_docs_data_size");
    public static final AttributeSensor<Long> COUCH_DOCS_ACTUAL_DISK_SIZE = Sensors.newLongSensor((String)"couchbase.stats.couch.docs.actual.disk.size", (String)"Retrieved from pools/nodes/<current node>/interestingStats/couch_docs_actual_disk_size");
    public static final AttributeSensor<Long> EP_BG_FETCHED = Sensors.newLongSensor((String)"couchbase.stats.ep.bg.fetched", (String)"Retrieved from pools/nodes/<current node>/interestingStats/ep_bg_fetched");
    public static final AttributeSensor<Long> MEM_USED = Sensors.newLongSensor((String)"couchbase.stats.mem.used", (String)"Retrieved from pools/nodes/<current node>/interestingStats/mem_used");
    public static final AttributeSensor<Long> COUCH_VIEWS_ACTUAL_DISK_SIZE = Sensors.newLongSensor((String)"couchbase.stats.couch.views.actual.disk.size", (String)"Retrieved from pools/nodes/<current node>/interestingStats/couch_views_actual_disk_size");
    public static final AttributeSensor<Long> CURR_ITEMS = Sensors.newLongSensor((String)"couchbase.stats.curr.items", (String)"Retrieved from pools/nodes/<current node>/interestingStats/curr_items");
    public static final AttributeSensor<Long> VB_REPLICA_CURR_ITEMS = Sensors.newLongSensor((String)"couchbase.stats.vb.replica.curr.items", (String)"Retrieved from pools/nodes/<current node>/interestingStats/vb_replica_curr_items");
    public static final AttributeSensor<Long> COUCH_VIEWS_DATA_SIZE = Sensors.newLongSensor((String)"couchbase.stats.couch.views.data.size", (String)"Retrieved from pools/nodes/<current node>/interestingStats/couch_views_data_size");
    public static final AttributeSensor<Long> GET_HITS = Sensors.newLongSensor((String)"couchbase.stats.get.hits", (String)"Retrieved from pools/nodes/<current node>/interestingStats/get_hits");
    public static final AttributeSensor<Double> CMD_GET = Sensors.newDoubleSensor((String)"couchbase.stats.cmd.get", (String)"Retrieved from pools/nodes/<current node>/interestingStats/cmd_get");
    public static final AttributeSensor<Long> CURR_ITEMS_TOT = Sensors.newLongSensor((String)"couchbase.stats.curr.items.tot", (String)"Retrieved from pools/nodes/<current node>/interestingStats/curr_items_tot");
    public static final AttributeSensor<String> REBALANCE_STATUS = Sensors.newStringSensor((String)"couchbase.rebalance.status", (String)"Displays the current rebalance status from pools/nodes/rebalanceStatus");
    public static final AttributeSensor<URI> MAIN_URI = MainUri.MAIN_URI;
    public static final MethodEffector<Void> SERVER_ADD = new MethodEffector(CouchbaseNode.class, "serverAdd");
    public static final MethodEffector<Void> SERVER_ADD_AND_REBALANCE = new MethodEffector(CouchbaseNode.class, "serverAddAndRebalance");
    public static final MethodEffector<Void> REBALANCE = new MethodEffector(CouchbaseNode.class, "rebalance");
    public static final MethodEffector<Void> BUCKET_CREATE = new MethodEffector(CouchbaseNode.class, "bucketCreate");
    public static final Effector<Void> ADD_REPLICATION_RULE = Effectors.effector(Void.class, (String)"addReplicationRule").description("Adds a replication rule from the indicated bucket on the cluster where this node is located to the indicated cluster and optional destination bucket").parameter(String.class, "fromBucket", "Bucket to be replicated").parameter(Object.class, "toCluster", "Entity (or ID) of the cluster to which this should replicate").parameter(String.class, "toBucket", "Destination bucket for replication in the toCluster, defaulting to the same as the fromBucket").buildAbstract();

    @brooklyn.entity.annotation.Effector(description="add a server to a cluster")
    public void serverAdd(@EffectorParam(name="serverHostname") String var1, @EffectorParam(name="username") String var2, @EffectorParam(name="password") String var3);

    @brooklyn.entity.annotation.Effector(description="add a server to a cluster, and immediately rebalances")
    public void serverAddAndRebalance(@EffectorParam(name="serverHostname") String var1, @EffectorParam(name="username") String var2, @EffectorParam(name="password") String var3);

    @brooklyn.entity.annotation.Effector(description="rebalance the couchbase cluster")
    public void rebalance();

    @brooklyn.entity.annotation.Effector(description="create a new bucket")
    public void bucketCreate(@EffectorParam(name="bucketName") String var1, @EffectorParam(name="bucketType") String var2, @EffectorParam(name="bucketPort") Integer var3, @EffectorParam(name="bucketRamSize") Integer var4, @EffectorParam(name="bucketReplica") Integer var5);

    public static class MainUri {
        public static final AttributeSensor<URI> MAIN_URI = Attributes.MAIN_URI;

        static {
            RendererHints.register(COUCHBASE_WEB_ADMIN_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
            RendererHints.register(COUCH_DOCS_DATA_SIZE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(COUCH_DOCS_ACTUAL_DISK_SIZE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(MEM_USED, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(COUCH_VIEWS_ACTUAL_DISK_SIZE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(COUCH_VIEWS_DATA_SIZE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
        }
    }
}

