/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.nosql.cassandra;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.DynamicGroup;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import brooklyn.entity.group.DynamicFabric;
import brooklyn.entity.group.DynamicFabricImpl;
import brooklyn.entity.nosql.cassandra.CassandraDatacenter;
import brooklyn.entity.nosql.cassandra.CassandraFabric;
import brooklyn.entity.nosql.cassandra.CassandraNode;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.location.Location;
import brooklyn.policy.PolicySpec;
import brooklyn.util.collections.CollectionFunctionals;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraFabricImpl
extends DynamicFabricImpl
implements CassandraFabric {
    private static final Logger log = LoggerFactory.getLogger(CassandraFabricImpl.class);
    private final Object mutex = new Object[0];
    private final Supplier<Set<Entity>> defaultSeedSupplier = new Supplier<Set<Entity>>(){

        public Set<Entity> get() {
            Set seeds = (Set)CassandraFabricImpl.this.getAttribute(CassandraFabric.CURRENT_SEEDS);
            boolean hasPublishedSeeds = Boolean.TRUE.equals(CassandraFabricImpl.this.getAttribute(CassandraFabric.HAS_PUBLISHED_SEEDS));
            int quorumSize = CassandraFabricImpl.this.getSeedQuorumSize();
            if (seeds == null || seeds.size() < quorumSize || this.containsDownEntity(seeds)) {
                Object newseeds;
                MutableMap potentialSeeds = MutableMap.of();
                int potentialSeedCount = 0;
                for (CassandraDatacenter member : Iterables.filter((Iterable)CassandraFabricImpl.this.getMembers(), CassandraDatacenter.class)) {
                    Set<Entity> dcPotentialSeeds = member.gatherPotentialSeeds();
                    potentialSeeds.put(member, dcPotentialSeeds);
                    potentialSeedCount += dcPotentialSeeds.size();
                }
                if (hasPublishedSeeds) {
                    Set currentSeeds = (Set)CassandraFabricImpl.this.getAttribute(CassandraFabric.CURRENT_SEEDS);
                    Lifecycle serviceState = (Lifecycle)CassandraFabricImpl.this.getAttribute(DynamicFabric.SERVICE_STATE_ACTUAL);
                    if (serviceState == Lifecycle.STARTING) {
                        if (Sets.intersection((Set)currentSeeds, (Set)ImmutableSet.copyOf((Iterable)Iterables.concat(potentialSeeds.values()))).isEmpty()) {
                            log.warn("Fabric {} lost all its seeds while starting! Subsequent failure likely, but changing seeds during startup would risk split-brain: seeds={}", new Object[]{CassandraFabricImpl.this, currentSeeds});
                        }
                        newseeds = currentSeeds;
                    } else if (serviceState == Lifecycle.STOPPING || serviceState == Lifecycle.STOPPED) {
                        if (log.isTraceEnabled()) {
                            log.trace("Fabric {} ignoring any potential seed-changes, because {}: seeds={}", new Object[]{CassandraFabricImpl.this, serviceState, currentSeeds});
                        }
                        newseeds = currentSeeds;
                    } else if (potentialSeedCount == 0) {
                        log.warn("Fabric {} has no seeds (after startup); leaving seeds as-is; but risks split-brain if these seeds come back up!", new Object[]{CassandraFabricImpl.this});
                        newseeds = currentSeeds;
                    } else if (!this.allNonEmpty(potentialSeeds.values())) {
                        log.warn("Fabric {} has datacenter with no seeds (after startup); leaving seeds as-is; but risks split-brain if these seeds come back up!", new Object[]{CassandraFabricImpl.this});
                        newseeds = currentSeeds;
                    } else {
                        Set<Entity> result = this.selectSeeds(quorumSize, (Map<CassandraDatacenter, ? extends Collection<Entity>>)potentialSeeds);
                        if (log.isDebugEnabled() && !Objects.equal((Object)seeds, result)) {
                            log.debug("Fabric {} updating seeds: chosen={}; potential={}", new Object[]{CassandraFabricImpl.this, result, potentialSeeds});
                        }
                        newseeds = result;
                    }
                } else if (potentialSeedCount < quorumSize) {
                    if (log.isDebugEnabled()) {
                        log.debug("Not setting seeds of fabric {} yet, because still waiting for quorum (need {}; have {} potentials from {} members)", new Object[]{CassandraFabricImpl.this, quorumSize, potentialSeedCount, CassandraFabricImpl.this.getMembers()});
                    }
                    newseeds = ImmutableSet.of();
                } else if (!this.allNonEmpty(potentialSeeds.values())) {
                    if (log.isDebugEnabled()) {
                        Map datacenterCounts = Maps.transformValues((Map)potentialSeeds, (Function)CollectionFunctionals.sizeFunction());
                        log.debug("Not setting seeds of fabric {} yet, because not all datacenters have seeds (sizes are {})", new Object[]{CassandraFabricImpl.this, datacenterCounts});
                    }
                    newseeds = ImmutableSet.of();
                } else {
                    Set<Entity> result = this.selectSeeds(quorumSize, (Map<CassandraDatacenter, ? extends Collection<Entity>>)potentialSeeds);
                    log.info("Fabric {} has reached seed quorum: seeds={}", new Object[]{CassandraFabricImpl.this, result});
                    newseeds = result;
                }
                if (!Objects.equal((Object)seeds, (Object)newseeds)) {
                    CassandraFabricImpl.this.setAttribute(CassandraFabric.CURRENT_SEEDS, newseeds);
                    if (newseeds != null && newseeds.size() > 0) {
                        CassandraFabricImpl.this.setAttribute(CassandraFabric.HAS_PUBLISHED_SEEDS, true);
                        for (CassandraDatacenter member : Iterables.filter((Iterable)CassandraFabricImpl.this.getMembers(), CassandraDatacenter.class)) {
                            member.update();
                        }
                    }
                    return newseeds;
                }
                return seeds;
            }
            if (log.isTraceEnabled()) {
                log.trace("Not refresheed seeds of fabric {}, because have quorum {} (of {} members), and none are down: seeds={}", new Object[]{CassandraFabricImpl.class, quorumSize, CassandraFabricImpl.this.getMembers().size(), seeds});
            }
            return seeds;
        }

        private boolean allNonEmpty(Collection<? extends Collection<Entity>> contenders) {
            for (Collection<Entity> collection : contenders) {
                if (!collection.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private Set<Entity> selectSeeds(int num, Map<CassandraDatacenter, ? extends Collection<Entity>> contenders) {
            ImmutableSet currentSeeds = CassandraFabricImpl.this.getAttribute(CassandraFabric.CURRENT_SEEDS) != null ? (Set)CassandraFabricImpl.this.getAttribute(CassandraFabric.CURRENT_SEEDS) : ImmutableSet.of();
            MutableSet result = MutableSet.of();
            result.addAll((Collection)Sets.intersection((Set)currentSeeds, (Set)ImmutableSet.copyOf(contenders.values())));
            for (CassandraDatacenter cluster : contenders.keySet()) {
                LinkedHashSet contendersInCluster = Sets.newLinkedHashSet((Iterable)contenders.get(cluster));
                if (contendersInCluster.size() <= 0 || !Sets.intersection((Set)result, (Set)contendersInCluster).isEmpty()) continue;
                result.add(Iterables.getFirst((Iterable)contendersInCluster, null));
            }
            result.addAll(Iterables.concat(contenders.values()));
            return ImmutableSet.copyOf((Iterable)Iterables.limit((Iterable)result, (int)num));
        }

        private boolean containsDownEntity(Set<Entity> seeds) {
            for (Entity seed : seeds) {
                if (this.isViableSeed(seed)) continue;
                return true;
            }
            return false;
        }

        public boolean isViableSeed(Entity member) {
            boolean result;
            boolean managed = Entities.isManaged((Entity)member);
            String hostname = (String)member.getAttribute(Attributes.HOSTNAME);
            boolean serviceUp = Boolean.TRUE.equals(member.getAttribute(Attributes.SERVICE_UP));
            Lifecycle serviceState = (Lifecycle)member.getAttribute(Attributes.SERVICE_STATE_ACTUAL);
            boolean hasFailed = !managed || serviceState == Lifecycle.ON_FIRE || serviceState == Lifecycle.RUNNING && !serviceUp || serviceState == Lifecycle.STOPPED;
            boolean bl = result = hostname != null && !hasFailed;
            if (log.isTraceEnabled()) {
                log.trace("Node {} in Fabric {}: viableSeed={}; hostname={}; serviceUp={}; serviceState={}; hasFailed={}", new Object[]{member, CassandraFabricImpl.this, result, hostname, serviceUp, serviceState, hasFailed});
            }
            return result;
        }
    };

    public void init() {
        super.init();
        if (!this.getConfigRaw(CassandraDatacenter.SEED_SUPPLIER, true).isPresentAndNonNull()) {
            this.setConfig(CassandraDatacenter.SEED_SUPPLIER, this.getSeedSupplier());
        }
        this.addPolicy(((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Cassandra Fabric Tracker")).configure((CharSequence)"group", (Object)this));
        this.subscribeToMembers((Group)this, (Sensor)CassandraDatacenter.FIRST_NODE_STARTED_TIME_UTC, (SensorEventListener)new SensorEventListener<Long>(){

            public void onEvent(SensorEvent<Long> event) {
                Long oldval = (Long)CassandraFabricImpl.this.getAttribute(CassandraDatacenter.FIRST_NODE_STARTED_TIME_UTC);
                Long newval = (Long)event.getValue();
                if (oldval == null && newval != null) {
                    CassandraFabricImpl.this.setAttribute(CassandraDatacenter.FIRST_NODE_STARTED_TIME_UTC, newval);
                    for (CassandraDatacenter member : Iterables.filter((Iterable)CassandraFabricImpl.this.getMembers(), CassandraDatacenter.class)) {
                        ((EntityInternal)member).setAttribute(CassandraDatacenter.FIRST_NODE_STARTED_TIME_UTC, (Object)newval);
                    }
                }
            }
        });
        this.subscribeToMembers((Group)this, (Sensor)CassandraDatacenter.DATACENTER_USAGE, (SensorEventListener)new SensorEventListener<Multimap<String, Entity>>(){

            public void onEvent(SensorEvent<Multimap<String, Entity>> event) {
                Multimap<String, Entity> usage = CassandraFabricImpl.this.calculateDatacenterUsage();
                CassandraFabricImpl.this.setAttribute(CassandraFabric.DATACENTER_USAGE, usage);
                CassandraFabricImpl.this.setAttribute(CassandraFabric.DATACENTERS, usage.keySet());
            }
        });
        this.subscribe((Entity)this, (Sensor)DynamicGroup.MEMBER_REMOVED, (SensorEventListener)new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                Multimap<String, Entity> usage = CassandraFabricImpl.this.calculateDatacenterUsage();
                CassandraFabricImpl.this.setAttribute(CassandraFabric.DATACENTER_USAGE, usage);
                CassandraFabricImpl.this.setAttribute(CassandraFabric.DATACENTERS, usage.keySet());
            }
        });
    }

    protected int getSeedQuorumSize() {
        Integer quorumSize = (Integer)this.getConfig(INITIAL_QUORUM_SIZE);
        if (quorumSize != null && quorumSize > 0) {
            return quorumSize;
        }
        int initialSizeSum = 0;
        for (CassandraDatacenter cluster : Iterables.filter((Iterable)this.getMembers(), CassandraDatacenter.class)) {
            initialSizeSum += ((Integer)cluster.getConfig((ConfigKey)CassandraDatacenter.INITIAL_SIZE)).intValue();
        }
        if (initialSizeSum > 5) {
            initialSizeSum /= 2;
        } else if (initialSizeSum > 3) {
            initialSizeSum -= 2;
        } else if (initialSizeSum > 2) {
            --initialSizeSum;
        }
        return Math.min(Math.max(initialSizeSum, 1), 5);
    }

    protected EntitySpec<?> getMemberSpec() {
        EntitySpec custom = (EntitySpec)this.getConfig(MEMBER_SPEC);
        if (custom == null) {
            return EntitySpec.create(CassandraDatacenter.class).configure(CassandraDatacenter.SEED_SUPPLIER, this.getSeedSupplier());
        }
        if (custom.getConfig().containsKey(CassandraDatacenter.SEED_SUPPLIER) || custom.getFlags().containsKey("seedSupplier")) {
            return custom;
        }
        return EntitySpec.create((EntitySpec)custom).configure(CassandraDatacenter.SEED_SUPPLIER, this.getSeedSupplier());
    }

    protected Entity createCluster(Location location, Map flags) {
        Function dataCenterNamer = (Function)this.getConfig(DATA_CENTER_NAMER);
        if (dataCenterNamer != null) {
            flags = ImmutableMap.builder().putAll(flags).put(CassandraNode.DATACENTER_NAME, dataCenterNamer.apply((Object)location)).build();
        }
        return super.createCluster(location, flags);
    }

    public Supplier<Set<Entity>> getSeedSupplier() {
        return this.defaultSeedSupplier;
    }

    public void start(Collection<? extends Location> locations) {
        super.start(locations);
        this.connectSensors();
        Time.sleep((Duration)((Duration)this.getConfig(CassandraDatacenter.DELAY_BEFORE_ADVERTISING_CLUSTER)));
        this.update();
    }

    protected void connectSensors() {
        this.connectEnrichers();
    }

    protected void connectEnrichers() {
        this.subscribeToMembers((Group)this, (Sensor)SERVICE_UP, (SensorEventListener)new SensorEventListener<Boolean>(){

            public void onEvent(SensorEvent<Boolean> event) {
                CassandraFabricImpl.this.setAttribute(Startable.SERVICE_UP, CassandraFabricImpl.this.calculateServiceUp());
            }
        });
    }

    public void stop() {
        this.disconnectSensors();
        super.stop();
    }

    protected void disconnectSensors() {
    }

    protected boolean calculateServiceUp() {
        Optional upNode = Iterables.tryFind((Iterable)this.getMembers(), (Predicate)EntityPredicates.attributeEqualTo((AttributeSensor)SERVICE_UP, (Object)Boolean.TRUE));
        return upNode.isPresent();
    }

    protected Multimap<String, Entity> calculateDatacenterUsage() {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (CassandraDatacenter member : Iterables.filter((Iterable)this.getMembers(), CassandraDatacenter.class)) {
            Multimap memberUsage = (Multimap)member.getAttribute(CassandraDatacenter.DATACENTER_USAGE);
            if (memberUsage == null) continue;
            result.putAll(memberUsage);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        Object object = this.mutex;
        synchronized (object) {
            for (CassandraDatacenter member : Iterables.filter((Iterable)this.getMembers(), CassandraDatacenter.class)) {
                member.update();
            }
            this.calculateServiceUp();
            Optional upNode = Iterables.tryFind((Iterable)this.getMembers(), (Predicate)EntityPredicates.attributeEqualTo((AttributeSensor)SERVICE_UP, (Object)Boolean.TRUE));
            if (upNode.isPresent()) {
                this.setAttribute(HOSTNAME, ((Entity)upNode.get()).getAttribute(Attributes.HOSTNAME));
                this.setAttribute(THRIFT_PORT, ((Entity)upNode.get()).getAttribute((AttributeSensor)CassandraNode.THRIFT_PORT));
            }
        }
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityChange(Entity member) {
            if (log.isDebugEnabled()) {
                log.debug("Location {} updated in Fabric {}", (Object)member, (Object)this.entity);
            }
            ((CassandraFabricImpl)this.entity).update();
        }

        protected void onEntityAdded(Entity member) {
            if (log.isDebugEnabled()) {
                log.debug("Location {} added to Fabric {}", (Object)member, (Object)this.entity);
            }
            ((CassandraFabricImpl)this.entity).update();
        }

        protected void onEntityRemoved(Entity member) {
            if (log.isDebugEnabled()) {
                log.debug("Location {} removed from Fabric {}", (Object)member, (Object)this.entity);
            }
            ((CassandraFabricImpl)this.entity).update();
        }
    }
}

