/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.jmx;

import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.PollConfig;
import brooklyn.event.feed.jmx.JmxHelper;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxOperationPollConfig<T>
extends PollConfig<Object, T, JmxOperationPollConfig<T>> {
    private ObjectName objectName;
    private String operationName;
    private List<String> signature = Collections.emptyList();
    private List<?> params = Collections.emptyList();

    public JmxOperationPollConfig(AttributeSensor<T> sensor) {
        super(sensor);
        this.onSuccess(Functions.identity());
    }

    public JmxOperationPollConfig(JmxOperationPollConfig<T> other) {
        super(other);
        this.objectName = other.objectName;
        this.operationName = other.operationName;
        this.signature = other.signature != null ? ImmutableList.copyOf(other.signature) : null;
        this.params = other.params != null ? ImmutableList.copyOf(other.params) : null;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public List<String> getSignature() {
        return this.signature;
    }

    public List<?> getParams() {
        return this.params;
    }

    public JmxOperationPollConfig<T> objectName(ObjectName val) {
        this.objectName = val;
        return this;
    }

    public JmxOperationPollConfig<T> objectName(String val) {
        try {
            return this.objectName(new ObjectName(val));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name (" + val + ")", e);
        }
    }

    public JmxOperationPollConfig<T> operationName(String val) {
        this.operationName = val;
        return this;
    }

    public JmxOperationPollConfig<T> operationSignature(List<String> val) {
        this.signature = val;
        return this;
    }

    public JmxOperationPollConfig<T> operationParams(List<?> val) {
        this.params = val;
        return this;
    }

    public List<?> buildOperationIdentity() {
        return ImmutableList.of((Object)this.operationName, this.buildSignature(), this.params);
    }

    private List<String> buildSignature() {
        if (this.signature != null && this.signature.size() == this.params.size()) {
            return this.signature;
        }
        LinkedList derivedSignature = Lists.newLinkedList();
        for (Object param : this.params) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = param != null ? param.getClass() : null;
            String clazzName = clazz != null ? (JmxHelper.CLASSES.containsKey(clazz.getSimpleName()) ? JmxHelper.CLASSES.get(clazz.getSimpleName()) : clazz.getName()) : Object.class.getName();
            derivedSignature.add(clazzName);
        }
        return derivedSignature;
    }

    protected String toStringBaseName() {
        return "jmx";
    }

    protected String toStringPollSource() {
        return this.objectName + ":" + this.operationName + (this.params != null ? this.params : "[]");
    }
}

