/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.jmx;

import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.PollConfig;
import com.google.common.base.Functions;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxAttributePollConfig<T>
extends PollConfig<Object, T, JmxAttributePollConfig<T>> {
    private ObjectName objectName;
    private String attributeName;

    public JmxAttributePollConfig(AttributeSensor<T> sensor) {
        super(sensor);
        this.onSuccess(Functions.identity());
    }

    public JmxAttributePollConfig(JmxAttributePollConfig<T> other) {
        super(other);
        this.objectName = other.objectName;
        this.attributeName = other.attributeName;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public JmxAttributePollConfig<T> objectName(ObjectName val) {
        this.objectName = val;
        return this;
    }

    public JmxAttributePollConfig<T> objectName(String val) {
        try {
            return this.objectName(new ObjectName(val));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name (" + val + ")", e);
        }
    }

    public JmxAttributePollConfig<T> attributeName(String val) {
        this.attributeName = val;
        return this;
    }

    protected String toStringBaseName() {
        return "jmx";
    }

    protected String toStringPollSource() {
        return this.objectName + ":" + this.attributeName;
    }
}

