/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.software.winrm;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.proxying.EntityInitializer;
import brooklyn.event.basic.Sensors;
import brooklyn.event.feed.windows.WindowsPerformanceCounterFeed;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.text.Strings;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsPerformanceCounterSensors
implements EntityInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsPerformanceCounterSensors.class);
    public static final ConfigKey<Set<Map<String, String>>> PERFORMANCE_COUNTERS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Set<Map<String, String>>>(){}, (String)"performance.counters");
    protected final Set<Map<String, String>> sensors;

    public WindowsPerformanceCounterSensors(ConfigBag params) {
        this.sensors = (Set)params.get(PERFORMANCE_COUNTERS);
    }

    public WindowsPerformanceCounterSensors(Map<String, String> params) {
        this(ConfigBag.newInstance(params));
    }

    public void apply(EntityLocal entity) {
        WindowsPerformanceCounterFeed.Builder builder = WindowsPerformanceCounterFeed.builder().entity(entity);
        for (Map<String, String> sensorConfig : this.sensors) {
            Class<String> clazz;
            String name = sensorConfig.get("name");
            String sensorType = sensorConfig.get("sensorType");
            try {
                clazz = Strings.isNonEmpty((CharSequence)sensorType) ? ((EntityInternal)entity).getManagementContext().getCatalog().getRootClassLoader().loadClass(sensorType) : String.class;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not load type " + sensorType + " for sensor " + name, e);
            }
            builder.addSensor(sensorConfig.get("counter"), Sensors.newSensor(clazz, (String)name, (String)sensorConfig.get("description")));
        }
        builder.build();
    }
}

