/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.software.ssh;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.effector.AddSensor;
import brooklyn.event.feed.ssh.SshFeed;
import brooklyn.event.feed.ssh.SshPollConfig;
import brooklyn.event.feed.ssh.SshValueFunctions;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.os.Os;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SshCommandSensor<T>
extends AddSensor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SshCommandSensor.class);
    public static final ConfigKey<String> SENSOR_COMMAND = ConfigKeys.newStringConfigKey((String)"command", (String)"SSH command to execute for sensor");
    public static final ConfigKey<String> SENSOR_EXECUTION_DIR = ConfigKeys.newStringConfigKey((String)"executionDir", (String)"Directory where the command should run; if not supplied, executes in the entity's run dir (or home dir if no run dir is defined); use '~' to always execute in the home dir, or 'custom-feed/' to execute in a custom-feed dir relative to the run dir");
    protected final String command;
    protected final String executionDir;

    public SshCommandSensor(ConfigBag params) {
        super(params);
        this.command = (String)Preconditions.checkNotNull((Object)params.get(SENSOR_COMMAND), (Object)"command");
        this.executionDir = (String)params.get(SENSOR_EXECUTION_DIR);
    }

    public void apply(final EntityLocal entity) {
        super.apply(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding SSH sensor {} to {}", (Object)this.name, (Object)entity);
        }
        Supplier<Map<String, String>> envSupplier = new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                return MutableMap.copyOf((Map)Strings.toStringMap((Map)((Map)entity.getConfig(SoftwareProcess.SHELL_ENVIRONMENT))));
            }
        };
        Supplier<String> commandSupplier = new Supplier<String>(){

            public String get() {
                return SshCommandSensor.makeCommandExecutingInDirectory(SshCommandSensor.this.command, SshCommandSensor.this.executionDir, entity);
            }
        };
        SshPollConfig pollConfig = (SshPollConfig)((SshPollConfig)((SshPollConfig)((SshPollConfig)new SshPollConfig(this.sensor).period(this.period)).env((Supplier)envSupplier).command((Supplier)commandSupplier).checkSuccess(SshValueFunctions.exitStatusEquals((int)0))).onFailureOrException(Functions.constant((Object)null))).onSuccess(Functions.compose((Function)new Function<String, T>(){

            public T apply(String input) {
                return TypeCoercions.coerce((Object)input, (Class)SshCommandSensor.this.getType(SshCommandSensor.this.type));
            }
        }, (Function)SshValueFunctions.stdout()));
        SshFeed.builder().entity(entity).onlyIfServiceUp().poll(pollConfig).build();
    }

    static String makeCommandExecutingInDirectory(String command, String executionDir, EntityLocal entity) {
        String runDir;
        String finalCommand = command;
        String execDir = executionDir;
        if (Strings.isBlank((CharSequence)execDir)) {
            execDir = (String)entity.getAttribute(SoftwareProcess.RUN_DIR);
            if (Strings.isBlank((CharSequence)execDir)) {
                execDir = "~";
            }
        } else if (!Os.isAbsolutish((String)execDir) && !Strings.isBlank((CharSequence)(runDir = (String)entity.getAttribute(SoftwareProcess.RUN_DIR)))) {
            execDir = Os.mergePaths((String[])new String[]{runDir, execDir});
        }
        if (!"~".equals(execDir)) {
            finalCommand = "mkdir -p '" + execDir + "' && cd '" + execDir + "' && " + finalCommand;
        }
        return finalCommand;
    }
}

