/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.software.ssh;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.ParameterType;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.effector.AddEffector;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.entity.software.ssh.SshCommandSensor;
import brooklyn.management.TaskFactory;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import java.util.Map;

public final class SshCommandEffector
extends AddEffector {
    public static final ConfigKey<String> EFFECTOR_COMMAND = ConfigKeys.newStringConfigKey((String)"command");
    public static final ConfigKey<String> EFFECTOR_EXECUTION_DIR = SshCommandSensor.SENSOR_EXECUTION_DIR;

    public SshCommandEffector(ConfigBag params) {
        super(SshCommandEffector.newEffectorBuilder(params).build());
    }

    public SshCommandEffector(Map<String, String> params) {
        this(ConfigBag.newInstance(params));
    }

    public static Effectors.EffectorBuilder<String> newEffectorBuilder(ConfigBag params) {
        Effectors.EffectorBuilder eff = AddEffector.newEffectorBuilder(String.class, (ConfigBag)params);
        eff.impl((EffectorBody)new Body(eff.buildAbstract(), params));
        return eff;
    }

    protected static class Body
    extends EffectorBody<String> {
        private final Effector<?> effector;
        private final String command;
        private final String executionDir;

        public Body(Effector<?> eff, ConfigBag params) {
            this.effector = eff;
            this.command = (String)Preconditions.checkNotNull((Object)params.get(EFFECTOR_COMMAND), (Object)"command must be supplied when defining this effector");
            this.executionDir = (String)params.get(EFFECTOR_EXECUTION_DIR);
        }

        public String call(ConfigBag params) {
            String command = this.command;
            command = SshCommandSensor.makeCommandExecutingInDirectory(command, this.executionDir, (EntityLocal)this.entity());
            MutableMap env = MutableMap.of();
            for (ParameterType param : this.effector.getParameters()) {
                env.addIfNotNull((Object)param.getName(), (Object)Strings.toString((Object)params.get(Effectors.asConfigKey((ParameterType)param))));
            }
            env.putAll(Strings.toStringMap((Map)((Map)this.entity().getConfig(SoftwareProcess.SHELL_ENVIRONMENT))));
            env.putAll(Strings.toStringMap((Map)params.getAllConfig()));
            SshEffectorTasks.SshEffectorTaskFactory t = (SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh(command).requiringZeroAndReturningStdout().summary("effector " + this.effector.getName())).environmentVariables((Map)env);
            return (String)((ProcessTaskWrapper)this.queue((TaskFactory)t)).get();
        }
    }
}

