/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.software.java;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.effector.AddSensor;
import brooklyn.entity.java.UsesJmx;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.event.feed.jmx.JmxAttributePollConfig;
import brooklyn.event.feed.jmx.JmxFeed;
import brooklyn.event.feed.jmx.JmxHelper;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class JmxAttributeSensor<T>
extends AddSensor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JmxAttributeSensor.class);
    public static final ConfigKey<String> OBJECT_NAME = ConfigKeys.newStringConfigKey((String)"objectName", (String)"JMX object name for sensor lookup");
    public static final ConfigKey<String> ATTRIBUTE = ConfigKeys.newStringConfigKey((String)"attribute", (String)"JMX attribute to poll in object");
    public static final ConfigKey<Object> DEFAULT_VALUE = ConfigKeys.newConfigKey(Object.class, (String)"defaultValue", (String)"Default value for sensor; normally null");
    protected final String objectName;
    protected final String attribute;
    protected final Object defaultValue;

    public JmxAttributeSensor(ConfigBag params) {
        super(params);
        this.objectName = (String)Preconditions.checkNotNull((Object)params.get(OBJECT_NAME), (Object)"objectName");
        this.attribute = (String)Preconditions.checkNotNull((Object)params.get(ATTRIBUTE), (Object)"attribute");
        this.defaultValue = params.get(DEFAULT_VALUE);
        try {
            ObjectName.getInstance(this.objectName);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException("Malformed JMX object name: " + this.objectName, mone);
        }
    }

    public void apply(final EntityLocal entity) {
        super.apply(entity);
        if (entity instanceof UsesJmx) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submitting task to add JMX sensor {} to {}", (Object)this.name, (Object)entity);
            }
        } else {
            throw new IllegalStateException(String.format("Entity %s does not support JMX", entity));
        }
        Task jmxPortTask = DependentConfiguration.attributeWhenReady((Entity)entity, (AttributeSensor)UsesJmx.JMX_PORT);
        Task jmxFeedTask = Tasks.builder().description("Add JMX feed").body((Callable)new Callable<JmxFeed>(){

            @Override
            public JmxFeed call() throws Exception {
                JmxHelper helper = new JmxHelper(entity);
                Duration period = (Duration)entity.getConfig(AddSensor.SENSOR_PERIOD);
                JmxFeed feed = JmxFeed.builder().entity(entity).period(period).helper(helper).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(JmxAttributeSensor.this.sensor).objectName(JmxAttributeSensor.this.objectName).attributeName(JmxAttributeSensor.this.attribute).onFailureOrException(Functions.constant((Object)JmxAttributeSensor.this.defaultValue))).build();
                return feed;
            }
        }).build();
        DynamicTasks.submit((TaskAdaptable)Tasks.sequential((String)("Add JMX Sensor " + this.sensor.getName()), (TaskAdaptable[])new TaskAdaptable[]{jmxPortTask, jmxFeedTask}), (Entity)entity);
    }
}

